/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.config;

import com.hazelcast.internal.util.Preconditions;
import com.hazelcast.jet.config.ResourceType;
import com.hazelcast.spi.annotation.PrivateApi;
import java.io.Serializable;
import java.net.URL;
import java.util.Objects;
import javax.annotation.Nonnull;

@PrivateApi
public class ResourceConfig
implements Serializable {
    private final URL url;
    private final String id;
    private final ResourceType resourceType;

    ResourceConfig(@Nonnull URL url, @Nonnull String id, @Nonnull ResourceType resourceType) {
        Preconditions.checkNotNull((Object)url, (String)"url");
        Preconditions.checkNotNull((Object)((Object)resourceType), (String)"resourceType");
        Preconditions.checkHasText((String)id, (String)"id cannot be null or empty");
        this.url = url;
        this.id = id;
        this.resourceType = resourceType;
    }

    ResourceConfig(@Nonnull Class<?> clazz) {
        Preconditions.checkNotNull(clazz, (String)"clazz");
        String id = clazz.getName().replace('.', '/') + ".class";
        URL url = clazz.getClassLoader().getResource(id);
        if (url == null) {
            throw new IllegalArgumentException("Couldn't derive URL from class " + clazz);
        }
        this.id = id;
        this.url = url;
        this.resourceType = ResourceType.CLASS;
    }

    @Nonnull
    public URL getUrl() {
        return this.url;
    }

    @Nonnull
    public String getId() {
        return this.id;
    }

    @Nonnull
    public ResourceType getResourceType() {
        return this.resourceType;
    }

    public String toString() {
        return "ResourceConfig{url=" + this.url + ", id='" + this.id + '\'' + ", resourceType=" + (Object)((Object)this.resourceType) + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ResourceConfig that = (ResourceConfig)o;
        return this.url.toString().equals(that.url.toString()) && this.id.equals(that.id) && this.resourceType == that.resourceType;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.url, this.id, this.resourceType});
    }
}

