/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.config;

import com.hazelcast.config.ConfigXmlGenerator;
import com.hazelcast.internal.nio.IOUtil;
import com.hazelcast.internal.util.Preconditions;
import com.hazelcast.jet.config.EdgeConfig;
import com.hazelcast.jet.config.InstanceConfig;
import com.hazelcast.jet.config.JetConfig;
import com.hazelcast.logging.ILogger;
import com.hazelcast.logging.Logger;
import java.io.Closeable;
import java.io.StringReader;
import java.io.StringWriter;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;

public final class JetConfigXmlGenerator {
    private static final ILogger LOGGER = Logger.getLogger(JetConfigXmlGenerator.class);

    private JetConfigXmlGenerator() {
    }

    public static String generate(JetConfig jetConfig) {
        return JetConfigXmlGenerator.generate(jetConfig, -1);
    }

    public static String generate(JetConfig jetConfig, int indent) {
        Preconditions.isNotNull((Object)jetConfig, (String)"JetConfig");
        StringBuilder xml = new StringBuilder();
        xml.append("<?xml version=\"1.0\" encoding=\"UTF-8\" ?>");
        ConfigXmlGenerator.XmlGenerator gen = new ConfigXmlGenerator.XmlGenerator(xml);
        gen.open("hazelcast-jet", new Object[]{"xmlns", "http://www.hazelcast.com/schema/jet-config", "xmlns:xsi", "http://www.w3.org/2001/XMLSchema-instance", "xsi:schemaLocation", "http://www.hazelcast.com/schema/jet-config http://www.hazelcast.com/schema/jet-config/hazelcast-jet-config-3.1.xsd"});
        gen.appendProperties(jetConfig.getProperties());
        JetConfigXmlGenerator.instance(gen, jetConfig.getInstanceConfig());
        JetConfigXmlGenerator.edgeDefaults(gen, jetConfig.getDefaultEdgeConfig());
        gen.close();
        return JetConfigXmlGenerator.format(xml.toString(), indent);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String format(String input, int indent) {
        if (indent < 0) {
            return input;
        }
        if (indent == 0) {
            throw new IllegalArgumentException("Indent should be greater than 0");
        }
        StreamResult xmlOutput = null;
        try {
            StreamSource xmlInput = new StreamSource(new StringReader(input));
            xmlOutput = new StreamResult(new StringWriter());
            TransformerFactory transformerFactory = TransformerFactory.newInstance();
            try {
                transformerFactory.setAttribute("indent-number", indent);
            }
            catch (IllegalArgumentException e) {
                JetConfigXmlGenerator.logFinest("Failed to set indent-number attribute; cause: " + e.getMessage());
            }
            Transformer transformer = transformerFactory.newTransformer();
            transformer.setOutputProperty("omit-xml-declaration", "yes");
            transformer.setOutputProperty("encoding", "UTF-8");
            transformer.setOutputProperty("indent", "yes");
            try {
                transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", Integer.toString(indent));
            }
            catch (IllegalArgumentException e) {
                JetConfigXmlGenerator.logFinest("Failed to set indent-amount property; cause: " + e.getMessage());
            }
            transformer.transform(xmlInput, xmlOutput);
            String string = xmlOutput.getWriter().toString();
            return string;
        }
        catch (Exception e) {
            LOGGER.warning((Throwable)e);
            String string = input;
            return string;
        }
        finally {
            if (xmlOutput != null) {
                IOUtil.closeResource((Closeable)xmlOutput.getWriter());
            }
        }
    }

    private static void logFinest(String message) {
        if (LOGGER.isFinestEnabled()) {
            LOGGER.finest(message);
        }
    }

    private static void edgeDefaults(ConfigXmlGenerator.XmlGenerator gen, EdgeConfig defaultEdge) {
        gen.open("edge-defaults", new Object[0]).node("queue-size", (Object)defaultEdge.getQueueSize(), new Object[0]).node("packet-size-limit", (Object)defaultEdge.getPacketSizeLimit(), new Object[0]).node("receive-window-multiplier", (Object)defaultEdge.getReceiveWindowMultiplier(), new Object[0]).close();
    }

    private static void instance(ConfigXmlGenerator.XmlGenerator gen, InstanceConfig instance) {
        gen.open("instance", new Object[0]).node("cooperative-thread-count", (Object)instance.getCooperativeThreadCount(), new Object[0]).node("flow-control-period", (Object)instance.getFlowControlPeriodMs(), new Object[0]).node("backup-count", (Object)instance.getBackupCount(), new Object[0]).node("scale-up-delay-millis", (Object)instance.getScaleUpDelayMillis(), new Object[0]).node("lossless-restart-enabled", (Object)instance.isLosslessRestartEnabled(), new Object[0]).close();
    }
}

