/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.aggregate;

import com.hazelcast.function.BiConsumerEx;
import com.hazelcast.function.FunctionEx;
import com.hazelcast.function.SupplierEx;
import com.hazelcast.jet.aggregate.AggregateOperation;
import com.hazelcast.jet.aggregate.AggregateOperation1;
import com.hazelcast.jet.aggregate.AggregateOperation2;
import com.hazelcast.jet.aggregate.AggregateOperation3;
import com.hazelcast.jet.datamodel.Tag;
import com.hazelcast.jet.impl.aggregate.AggregateOperation1Impl;
import com.hazelcast.jet.impl.aggregate.AggregateOperation2Impl;
import com.hazelcast.jet.impl.aggregate.AggregateOperation3Impl;
import com.hazelcast.jet.impl.aggregate.AggregateOperationImpl;
import com.hazelcast.jet.impl.util.Util;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public final class AggregateOperationBuilder<A> {
    @Nonnull
    private final SupplierEx<A> createFn;

    AggregateOperationBuilder(@Nonnull SupplierEx<A> createFn) {
        this.createFn = createFn;
    }

    @Nonnull
    public <T> Arity1<T, A, Void> andAccumulate(@Nonnull BiConsumerEx<? super A, ? super T> accumulateFn) {
        Util.checkSerializable(accumulateFn, "accumulateFn");
        return new Arity1(this.createFn, accumulateFn);
    }

    @Nonnull
    public <T0> Arity1<T0, A, Void> andAccumulate0(@Nonnull BiConsumerEx<? super A, ? super T0> accumulateFn0) {
        Util.checkSerializable(accumulateFn0, "accumulateFn0");
        return new Arity1(this.createFn, accumulateFn0);
    }

    public VarArity<A, Void> varArity() {
        return new VarArity(this.createFn);
    }

    @Nonnull
    public <T> VarArity<A, Void> andAccumulate(@Nonnull Tag<T> tag, @Nonnull BiConsumerEx<? super A, ? super T> accumulateFn) {
        Util.checkSerializable(accumulateFn, "accumulateFn");
        return new VarArity(this.createFn, tag, accumulateFn);
    }

    public static class VarArity<A, R> {
        @Nonnull
        private final SupplierEx<A> createFn;
        private final Map<Integer, BiConsumerEx<? super A, ?>> accumulateFnsByTag = new HashMap();
        private BiConsumerEx<? super A, ? super A> combineFn;
        private BiConsumerEx<? super A, ? super A> deductFn;
        private FunctionEx<? super A, ? extends R> exportFn;

        VarArity(@Nonnull SupplierEx<A> createFn) {
            this.createFn = createFn;
        }

        <T> VarArity(@Nonnull SupplierEx<A> createFn, @Nonnull Tag<T> tag, @Nonnull BiConsumerEx<? super A, ? super T> accumulateFn) {
            this(createFn);
            this.accumulateFnsByTag.put(tag.index(), accumulateFn);
        }

        @Nonnull
        public <T> VarArity<A, R> andAccumulate(@Nonnull Tag<T> tag, @Nonnull BiConsumerEx<? super A, T> accumulateFn) {
            Util.checkSerializable(accumulateFn, "accumulateFn");
            if (this.accumulateFnsByTag.putIfAbsent(tag.index(), accumulateFn) != null) {
                throw new IllegalArgumentException("Tag with index " + tag.index() + " already registered");
            }
            return this;
        }

        @Nonnull
        public VarArity<A, R> andCombine(@Nullable BiConsumerEx<? super A, ? super A> combineFn) {
            Util.checkSerializable(combineFn, "combineFn");
            this.combineFn = combineFn;
            return this;
        }

        @Nonnull
        public VarArity<A, R> andDeduct(@Nullable BiConsumerEx<? super A, ? super A> deductFn) {
            Util.checkSerializable(deductFn, "deductFn");
            this.deductFn = deductFn;
            return this;
        }

        @Nonnull
        public <R_NEW> VarArity<A, R_NEW> andExport(@Nonnull FunctionEx<? super A, ? extends R_NEW> exportFn) {
            Util.checkSerializable(exportFn, "exportFn");
            VarArity newThis = this;
            newThis.exportFn = exportFn;
            return newThis;
        }

        @Nonnull
        public AggregateOperation<A, R> andFinish(@Nonnull FunctionEx<? super A, ? extends R> finishFn) {
            if (this.exportFn == null) {
                throw new IllegalStateException("The export primitive is not registered. Either add the missing andExport() call or use andExportFinish() to register the same function as both the export and finish primitive");
            }
            Util.checkSerializable(finishFn, "finishFn");
            return new AggregateOperationImpl<A, R>(this.createFn, this.packAccumulateFns(), this.combineFn, this.deductFn, this.exportFn, finishFn);
        }

        @Nonnull
        public <R_NEW> AggregateOperation<A, R_NEW> andExportFinish(@Nonnull FunctionEx<? super A, ? extends R_NEW> exportFinishFn) {
            if (this.exportFn != null) {
                throw new IllegalStateException("The export primitive is already registered. Call andFinish() if you want to register a separate finish primitive.");
            }
            Util.checkSerializable(exportFinishFn, "exportFinishFn");
            return new AggregateOperationImpl<A, R_NEW>(this.createFn, this.packAccumulateFns(), this.combineFn, this.deductFn, exportFinishFn, exportFinishFn);
        }

        private BiConsumerEx<? super A, ?>[] packAccumulateFns() {
            int size = this.accumulateFnsByTag.size();
            BiConsumerEx[] accFns = new BiConsumerEx[size];
            for (int i = 0; i < size; ++i) {
                accFns[i] = this.accumulateFnsByTag.get(i);
                if (accFns[i] != null) continue;
                throw new IllegalStateException("Registered tags' indices are " + this.accumulateFnsByTag.keySet().stream().sorted().collect(Collectors.toList()) + " but should be " + IntStream.range(0, size).boxed().collect(Collectors.toList()));
            }
            return accFns;
        }
    }

    public static class Arity3<T0, T1, T2, A, R> {
        @Nonnull
        private final SupplierEx<A> createFn;
        @Nonnull
        private final BiConsumerEx<? super A, ? super T0> accumulateFn0;
        @Nonnull
        private final BiConsumerEx<? super A, ? super T1> accumulateFn1;
        @Nonnull
        private final BiConsumerEx<? super A, ? super T2> accumulateFn2;
        private BiConsumerEx<? super A, ? super A> combineFn;
        private BiConsumerEx<? super A, ? super A> deductFn;
        private FunctionEx<? super A, ? extends R> exportFn;

        Arity3(Arity2<T0, T1, A, R> arity2, BiConsumerEx<? super A, ? super T2> accumulateFn2) {
            this.createFn = ((Arity2)arity2).createFn;
            this.accumulateFn0 = ((Arity2)arity2).accumulateFn0;
            this.accumulateFn1 = ((Arity2)arity2).accumulateFn1;
            this.accumulateFn2 = accumulateFn2;
        }

        @Nonnull
        public Arity3<T0, T1, T2, A, R> andCombine(@Nullable BiConsumerEx<? super A, ? super A> combineFn) {
            Util.checkSerializable(combineFn, "combineFn");
            this.combineFn = combineFn;
            return this;
        }

        @Nonnull
        public Arity3<T0, T1, T2, A, R> andDeduct(@Nullable BiConsumerEx<? super A, ? super A> deductFn) {
            Util.checkSerializable(deductFn, "deductFn");
            this.deductFn = deductFn;
            return this;
        }

        @Nonnull
        public <R_NEW> Arity3<T0, T1, T2, A, R_NEW> andExport(@Nonnull FunctionEx<? super A, ? extends R_NEW> exportFn) {
            Util.checkSerializable(exportFn, "exportFn");
            Arity3 newThis = this;
            newThis.exportFn = exportFn;
            return newThis;
        }

        @Nonnull
        public AggregateOperation3<T0, T1, T2, A, R> andFinish(@Nonnull FunctionEx<? super A, ? extends R> finishFn) {
            if (this.exportFn == null) {
                throw new IllegalStateException("The export primitive is not registered. Either add the missing andExport() call or use andExportFinish() to register the same function as both the export and finish primitive");
            }
            Util.checkSerializable(finishFn, "finishFn");
            return new AggregateOperation3Impl<T0, T1, T2, A, R>(this.createFn, this.accumulateFn0, this.accumulateFn1, this.accumulateFn2, this.combineFn, this.deductFn, this.exportFn, finishFn);
        }

        @Nonnull
        public <R_NEW> AggregateOperation3<T0, T1, T2, A, R_NEW> andExportFinish(@Nonnull FunctionEx<? super A, ? extends R_NEW> exportFinishFn) {
            Util.checkSerializable(exportFinishFn, "exportFinishFn");
            return new AggregateOperation3Impl<T0, T1, T2, A, R_NEW>(this.createFn, this.accumulateFn0, this.accumulateFn1, this.accumulateFn2, this.combineFn, this.deductFn, exportFinishFn, exportFinishFn);
        }
    }

    public static class Arity2<T0, T1, A, R> {
        @Nonnull
        private final SupplierEx<A> createFn;
        @Nonnull
        private final BiConsumerEx<? super A, ? super T0> accumulateFn0;
        @Nonnull
        private final BiConsumerEx<? super A, ? super T1> accumulateFn1;
        private BiConsumerEx<? super A, ? super A> combineFn;
        private BiConsumerEx<? super A, ? super A> deductFn;
        private FunctionEx<? super A, ? extends R> exportFn;

        Arity2(@Nonnull Arity1<T0, A, R> step1, @Nonnull BiConsumerEx<? super A, ? super T1> accumulateFn1) {
            this.createFn = ((Arity1)step1).createFn;
            this.accumulateFn0 = ((Arity1)step1).accumulateFn0;
            this.accumulateFn1 = accumulateFn1;
        }

        @Nonnull
        public <T2> Arity3<T0, T1, T2, A, R> andAccumulate2(@Nonnull BiConsumerEx<? super A, ? super T2> accumulateFn2) {
            Util.checkSerializable(accumulateFn2, "accumulateFn2");
            return new Arity3(this, accumulateFn2);
        }

        @Nonnull
        public Arity2<T0, T1, A, R> andCombine(@Nullable BiConsumerEx<? super A, ? super A> combineFn) {
            Util.checkSerializable(combineFn, "combineFn");
            this.combineFn = combineFn;
            return this;
        }

        @Nonnull
        public Arity2<T0, T1, A, R> andDeduct(@Nullable BiConsumerEx<? super A, ? super A> deductFn) {
            Util.checkSerializable(deductFn, "deductFn");
            this.deductFn = deductFn;
            return this;
        }

        @Nonnull
        public <R_NEW> Arity2<T0, T1, A, R_NEW> andExport(@Nonnull FunctionEx<? super A, ? extends R_NEW> exportFn) {
            Util.checkSerializable(exportFn, "exportFn");
            Arity2 newThis = this;
            newThis.exportFn = exportFn;
            return newThis;
        }

        @Nonnull
        public AggregateOperation2<T0, T1, A, R> andFinish(@Nonnull FunctionEx<? super A, ? extends R> finishFn) {
            Util.checkSerializable(finishFn, "finishFn");
            if (this.exportFn == null) {
                throw new IllegalStateException("The export primitive is not registered. Either add the missing andExport() call or use andExportFinish() to register the same function as both the export and finish primitive");
            }
            return new AggregateOperation2Impl<T0, T1, A, R>(this.createFn, this.accumulateFn0, this.accumulateFn1, this.combineFn, this.deductFn, this.exportFn, finishFn);
        }

        @Nonnull
        public <R_NEW> AggregateOperation2<T0, T1, A, R_NEW> andExportFinish(@Nonnull FunctionEx<? super A, ? extends R_NEW> exportFinishFn) {
            return new AggregateOperation2Impl<T0, T1, A, R_NEW>(this.createFn, this.accumulateFn0, this.accumulateFn1, this.combineFn, this.deductFn, exportFinishFn, exportFinishFn);
        }
    }

    public static class Arity1<T0, A, R> {
        @Nonnull
        private final SupplierEx<A> createFn;
        @Nonnull
        private final BiConsumerEx<? super A, ? super T0> accumulateFn0;
        private BiConsumerEx<? super A, ? super A> combineFn;
        private BiConsumerEx<? super A, ? super A> deductFn;
        private FunctionEx<? super A, ? extends R> exportFn;

        Arity1(@Nonnull SupplierEx<A> createFn, @Nonnull BiConsumerEx<? super A, ? super T0> accumulateFn0) {
            this.createFn = createFn;
            this.accumulateFn0 = accumulateFn0;
        }

        @Nonnull
        public <T1> Arity2<T0, T1, A, R> andAccumulate1(@Nonnull BiConsumerEx<? super A, ? super T1> accumulateFn1) {
            Util.checkSerializable(accumulateFn1, "accumulateFn1");
            return new Arity2(this, accumulateFn1);
        }

        @Nonnull
        public Arity1<T0, A, R> andCombine(@Nullable BiConsumerEx<? super A, ? super A> combineFn) {
            Util.checkSerializable(combineFn, "combineFn");
            this.combineFn = combineFn;
            return this;
        }

        @Nonnull
        public Arity1<T0, A, R> andDeduct(@Nullable BiConsumerEx<? super A, ? super A> deductFn) {
            Util.checkSerializable(deductFn, "deductFn");
            this.deductFn = deductFn;
            return this;
        }

        @Nonnull
        public <R_NEW> Arity1<T0, A, R_NEW> andExport(@Nonnull FunctionEx<? super A, ? extends R_NEW> exportFn) {
            Util.checkSerializable(exportFn, "exportFn");
            Arity1 newThis = this;
            newThis.exportFn = exportFn;
            return newThis;
        }

        @Nonnull
        public AggregateOperation1<T0, A, R> andFinish(@Nonnull FunctionEx<? super A, ? extends R> finishFn) {
            if (this.exportFn == null) {
                throw new IllegalStateException("The export primitive is not registered. Either add the missing andExport() call or use andExportFinish() to register the same function as both the export and finish primitive");
            }
            Util.checkSerializable(finishFn, "finishFn");
            return new AggregateOperation1Impl<T0, A, R>(this.createFn, this.accumulateFn0, this.combineFn, this.deductFn, this.exportFn, finishFn);
        }

        @Nonnull
        public <R_NEW> AggregateOperation1<T0, A, R_NEW> andExportFinish(@Nonnull FunctionEx<? super A, ? extends R_NEW> exportFinishFn) {
            if (this.exportFn != null) {
                throw new IllegalStateException("The export primitive is already registered. Call andFinish() if you want to register a separate finish primitive.");
            }
            Util.checkSerializable(exportFinishFn, "exportFinishFn");
            return new AggregateOperation1Impl<T0, A, R_NEW>(this.createFn, this.accumulateFn0, this.combineFn, this.deductFn, exportFinishFn, exportFinishFn);
        }
    }
}

