/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.pipeline;

import com.hazelcast.cache.journal.EventJournalCacheEvent;
import com.hazelcast.client.config.ClientConfig;
import com.hazelcast.core.IList;
import com.hazelcast.core.IMap;
import com.hazelcast.jet.Util;
import com.hazelcast.jet.core.EventTimePolicy;
import com.hazelcast.jet.core.ProcessorMetaSupplier;
import com.hazelcast.jet.core.processor.SourceProcessors;
import com.hazelcast.jet.function.FunctionEx;
import com.hazelcast.jet.function.PredicateEx;
import com.hazelcast.jet.function.SupplierEx;
import com.hazelcast.jet.function.ToResultSetFunction;
import com.hazelcast.jet.impl.pipeline.transform.BatchSourceTransform;
import com.hazelcast.jet.impl.pipeline.transform.StreamSourceTransform;
import com.hazelcast.jet.pipeline.BatchSource;
import com.hazelcast.jet.pipeline.FileSourceBuilder;
import com.hazelcast.jet.pipeline.JmsSourceBuilder;
import com.hazelcast.jet.pipeline.JournalInitialPosition;
import com.hazelcast.jet.pipeline.StreamSource;
import com.hazelcast.map.journal.EventJournalMapEvent;
import com.hazelcast.projection.Projection;
import com.hazelcast.query.Predicate;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.sql.Connection;
import java.sql.ResultSet;
import java.util.Map;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.jms.ConnectionFactory;
import javax.jms.Message;

public final class Sources {
    private Sources() {
    }

    @Nonnull
    public static <T> BatchSource<T> batchFromProcessor(@Nonnull String sourceName, @Nonnull ProcessorMetaSupplier metaSupplier) {
        com.hazelcast.jet.impl.util.Util.checkSerializable(metaSupplier, "metaSupplier");
        return new BatchSourceTransform(sourceName, metaSupplier);
    }

    @Nonnull
    public static <T> StreamSource<T> streamFromProcessorWithWatermarks(@Nonnull String sourceName, @Nonnull Function<EventTimePolicy<? super T>, ProcessorMetaSupplier> metaSupplierFn, boolean supportsNativeTimestamps) {
        return new StreamSourceTransform<T>(sourceName, metaSupplierFn, true, supportsNativeTimestamps);
    }

    @Nonnull
    public static <T> StreamSource<T> streamFromProcessor(@Nonnull String sourceName, @Nonnull ProcessorMetaSupplier metaSupplier) {
        com.hazelcast.jet.impl.util.Util.checkSerializable(metaSupplier, "metaSupplier");
        return new StreamSourceTransform(sourceName, w -> metaSupplier, false, false);
    }

    @Nonnull
    public static <K, V> BatchSource<Map.Entry<K, V>> map(@Nonnull String mapName) {
        return Sources.batchFromProcessor("mapSource(" + mapName + ')', SourceProcessors.readMapP(mapName));
    }

    @Nonnull
    public static <K, V> BatchSource<Map.Entry<K, V>> map(@Nonnull IMap<? extends K, ? extends V> map) {
        return Sources.map(map.getName());
    }

    @Nonnull
    public static <T, K, V> BatchSource<T> map(@Nonnull String mapName, @Nonnull Predicate<? super K, ? super V> predicate, @Nonnull Projection<? super Map.Entry<K, V>, ? extends T> projection) {
        return Sources.batchFromProcessor("mapSource(" + mapName + ')', SourceProcessors.readMapP(mapName, predicate, projection));
    }

    @Nonnull
    public static <T, K, V> BatchSource<T> map(@Nonnull IMap<? extends K, ? extends V> map, @Nonnull Predicate<? super K, ? super V> predicate, @Nonnull Projection<? super Map.Entry<K, V>, ? extends T> projection) {
        return Sources.map(map.getName(), predicate, projection);
    }

    @Nonnull
    public static <T, K, V> BatchSource<T> map(@Nonnull String mapName, @Nonnull Predicate<? super K, ? super V> predicate, @Nonnull FunctionEx<? super Map.Entry<K, V>, ? extends T> projection) {
        return Sources.batchFromProcessor("mapSource(" + mapName + ')', SourceProcessors.readMapP(mapName, predicate, projection));
    }

    @Nonnull
    public static <T, K, V> BatchSource<T> map(@Nonnull IMap<? extends K, ? extends V> map, @Nonnull Predicate<? super K, ? super V> predicate, @Nonnull FunctionEx<? super Map.Entry<K, V>, ? extends T> projection) {
        return Sources.map(map.getName(), predicate, projection);
    }

    @Nonnull
    public static <T, K, V> StreamSource<T> mapJournal(@Nonnull String mapName, @Nonnull PredicateEx<? super EventJournalMapEvent<K, V>> predicateFn, @Nonnull FunctionEx<? super EventJournalMapEvent<K, V>, ? extends T> projectionFn, @Nonnull JournalInitialPosition initialPos) {
        return Sources.streamFromProcessorWithWatermarks("mapJournalSource(" + mapName + ')', w -> SourceProcessors.streamMapP(mapName, predicateFn, projectionFn, initialPos, w), false);
    }

    @Nonnull
    public static <T, K, V> StreamSource<T> mapJournal(@Nonnull IMap<? extends K, ? extends V> map, @Nonnull PredicateEx<? super EventJournalMapEvent<K, V>> predicateFn, @Nonnull FunctionEx<? super EventJournalMapEvent<K, V>, ? extends T> projectionFn, @Nonnull JournalInitialPosition initialPos) {
        return Sources.mapJournal(map.getName(), predicateFn, projectionFn, initialPos);
    }

    @Nonnull
    public static <K, V> StreamSource<Map.Entry<K, V>> mapJournal(@Nonnull String mapName, @Nonnull JournalInitialPosition initialPos) {
        return Sources.mapJournal(mapName, Util.mapPutEvents(), Util.mapEventToEntry(), initialPos);
    }

    @Nonnull
    public static <K, V> StreamSource<Map.Entry<K, V>> mapJournal(@Nonnull IMap<? extends K, ? extends V> map, @Nonnull JournalInitialPosition initialPos) {
        return Sources.mapJournal(map.getName(), Util.mapPutEvents(), Util.mapEventToEntry(), initialPos);
    }

    @Nonnull
    public static <K, V> BatchSource<Map.Entry<K, V>> remoteMap(@Nonnull String mapName, @Nonnull ClientConfig clientConfig) {
        return Sources.batchFromProcessor("remoteMapSource(" + mapName + ')', ProcessorMetaSupplier.of(SourceProcessors.readRemoteMapP(mapName, clientConfig)));
    }

    @Nonnull
    public static <T, K, V> BatchSource<T> remoteMap(@Nonnull String mapName, @Nonnull ClientConfig clientConfig, @Nonnull Predicate<? super K, ? super V> predicate, @Nonnull Projection<? super Map.Entry<K, V>, ? extends T> projection) {
        return Sources.batchFromProcessor("remoteMapSource(" + mapName + ')', ProcessorMetaSupplier.of(SourceProcessors.readRemoteMapP(mapName, clientConfig, predicate, projection)));
    }

    @Nonnull
    public static <T, K, V> BatchSource<T> remoteMap(@Nonnull String mapName, @Nonnull ClientConfig clientConfig, @Nonnull Predicate<? super K, ? super V> predicate, @Nonnull FunctionEx<? super Map.Entry<K, V>, ? extends T> projection) {
        return Sources.batchFromProcessor("remoteMapSource(" + mapName + ')', ProcessorMetaSupplier.of(SourceProcessors.readRemoteMapP(mapName, clientConfig, predicate, projection)));
    }

    @Nonnull
    public static <T, K, V> StreamSource<T> remoteMapJournal(@Nonnull String mapName, @Nonnull ClientConfig clientConfig, @Nonnull PredicateEx<? super EventJournalMapEvent<K, V>> predicateFn, @Nonnull FunctionEx<? super EventJournalMapEvent<K, V>, ? extends T> projectionFn, @Nonnull JournalInitialPosition initialPos) {
        return Sources.streamFromProcessorWithWatermarks("remoteMapJournalSource(" + mapName + ')', w -> SourceProcessors.streamRemoteMapP(mapName, clientConfig, predicateFn, projectionFn, initialPos, w), false);
    }

    @Nonnull
    public static <K, V> StreamSource<Map.Entry<K, V>> remoteMapJournal(@Nonnull String mapName, @Nonnull ClientConfig clientConfig, @Nonnull JournalInitialPosition initialPos) {
        return Sources.remoteMapJournal(mapName, clientConfig, Util.mapPutEvents(), Util.mapEventToEntry(), initialPos);
    }

    @Nonnull
    public static <K, V> BatchSource<Map.Entry<K, V>> cache(@Nonnull String cacheName) {
        return Sources.batchFromProcessor("cacheSource(" + cacheName + ')', SourceProcessors.readCacheP(cacheName));
    }

    @Nonnull
    public static <T, K, V> StreamSource<T> cacheJournal(@Nonnull String cacheName, @Nonnull PredicateEx<? super EventJournalCacheEvent<K, V>> predicateFn, @Nonnull FunctionEx<? super EventJournalCacheEvent<K, V>, ? extends T> projectionFn, @Nonnull JournalInitialPosition initialPos) {
        return Sources.streamFromProcessorWithWatermarks("cacheJournalSource(" + cacheName + ')', w -> SourceProcessors.streamCacheP(cacheName, predicateFn, projectionFn, initialPos, w), false);
    }

    @Nonnull
    public static <K, V> StreamSource<Map.Entry<K, V>> cacheJournal(@Nonnull String cacheName, @Nonnull JournalInitialPosition initialPos) {
        return Sources.cacheJournal(cacheName, Util.cachePutEvents(), Util.cacheEventToEntry(), initialPos);
    }

    @Nonnull
    public static <K, V> BatchSource<Map.Entry<K, V>> remoteCache(@Nonnull String cacheName, @Nonnull ClientConfig clientConfig) {
        return Sources.batchFromProcessor("remoteCacheSource(" + cacheName + ')', ProcessorMetaSupplier.of(SourceProcessors.readRemoteCacheP(cacheName, clientConfig)));
    }

    @Nonnull
    public static <T, K, V> StreamSource<T> remoteCacheJournal(@Nonnull String cacheName, @Nonnull ClientConfig clientConfig, @Nonnull PredicateEx<? super EventJournalCacheEvent<K, V>> predicateFn, @Nonnull FunctionEx<? super EventJournalCacheEvent<K, V>, ? extends T> projectionFn, @Nonnull JournalInitialPosition initialPos) {
        return Sources.streamFromProcessorWithWatermarks("remoteCacheJournalSource(" + cacheName + ')', w -> SourceProcessors.streamRemoteCacheP(cacheName, clientConfig, predicateFn, projectionFn, initialPos, w), false);
    }

    @Nonnull
    public static <K, V> StreamSource<Map.Entry<K, V>> remoteCacheJournal(@Nonnull String cacheName, @Nonnull ClientConfig clientConfig, @Nonnull JournalInitialPosition initialPos) {
        return Sources.remoteCacheJournal(cacheName, clientConfig, Util.cachePutEvents(), Util.cacheEventToEntry(), initialPos);
    }

    @Nonnull
    public static <T> BatchSource<T> list(@Nonnull String listName) {
        return Sources.batchFromProcessor("listSource(" + listName + ')', SourceProcessors.readListP(listName));
    }

    @Nonnull
    public static <T> BatchSource<T> list(@Nonnull IList<? extends T> list) {
        return Sources.list(list.getName());
    }

    @Nonnull
    public static <T> BatchSource<T> remoteList(@Nonnull String listName, @Nonnull ClientConfig clientConfig) {
        return Sources.batchFromProcessor("remoteListSource(" + listName + ')', SourceProcessors.readRemoteListP(listName, clientConfig));
    }

    @Nonnull
    public static StreamSource<String> socket(@Nonnull String host, int port, @Nonnull Charset charset) {
        return Sources.streamFromProcessor("socketSource(" + host + ':' + port + ')', SourceProcessors.streamSocketP(host, port, charset));
    }

    @Nonnull
    public static StreamSource<String> socket(@Nonnull String host, int port) {
        return Sources.socket(host, port, StandardCharsets.UTF_8);
    }

    @Nonnull
    public static FileSourceBuilder filesBuilder(@Nonnull String directory) {
        return new FileSourceBuilder(directory);
    }

    @Nonnull
    public static BatchSource<String> files(@Nonnull String directory) {
        return Sources.filesBuilder(directory).build();
    }

    @Nonnull
    public static StreamSource<String> fileWatcher(@Nonnull String watchedDirectory) {
        return Sources.filesBuilder(watchedDirectory).buildWatcher();
    }

    @Nonnull
    public static StreamSource<Message> jmsQueue(@Nonnull SupplierEx<? extends ConnectionFactory> factorySupplier, @Nonnull String name) {
        return Sources.jmsQueueBuilder(factorySupplier).destinationName(name).build();
    }

    @Nonnull
    public static JmsSourceBuilder jmsQueueBuilder(SupplierEx<? extends ConnectionFactory> factorySupplier) {
        return new JmsSourceBuilder(factorySupplier, false);
    }

    @Nonnull
    public static StreamSource<Message> jmsTopic(@Nonnull SupplierEx<? extends ConnectionFactory> factorySupplier, @Nonnull String name) {
        return Sources.jmsTopicBuilder(factorySupplier).destinationName(name).build();
    }

    @Nonnull
    public static JmsSourceBuilder jmsTopicBuilder(SupplierEx<? extends ConnectionFactory> factorySupplier) {
        return new JmsSourceBuilder(factorySupplier, true);
    }

    public static <T> BatchSource<T> jdbc(@Nonnull SupplierEx<? extends Connection> newConnectionFn, @Nonnull ToResultSetFunction resultSetFn, @Nonnull FunctionEx<? super ResultSet, ? extends T> createOutputFn) {
        return Sources.batchFromProcessor("jdbcSource", SourceProcessors.readJdbcP(newConnectionFn, resultSetFn, createOutputFn));
    }

    public static <T> BatchSource<T> jdbc(@Nonnull String connectionURL, @Nonnull String query, @Nonnull FunctionEx<? super ResultSet, ? extends T> createOutputFn) {
        return Sources.batchFromProcessor("jdbcSource", SourceProcessors.readJdbcP(connectionURL, query, createOutputFn));
    }
}

