/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.impl.serialization;

import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.Serializer;
import com.hazelcast.nio.serialization.SerializerHook;
import com.hazelcast.nio.serialization.StreamSerializer;
import java.io.IOException;

public final class ObjectArrayHook
implements SerializerHook<Object[]> {
    public Class<Object[]> getSerializationType() {
        return Object[].class;
    }

    public Serializer createSerializer() {
        return new StreamSerializer<Object[]>(){

            public int getTypeId() {
                return -302;
            }

            public void destroy() {
            }

            public void write(ObjectDataOutput out, Object[] array) throws IOException {
                out.writeInt(array.length);
                for (int i = 0; i < array.length; ++i) {
                    out.writeObject(array[i]);
                }
            }

            public Object[] read(ObjectDataInput in) throws IOException {
                int length = in.readInt();
                Object[] array = new Object[length];
                for (int i = 0; i < array.length; ++i) {
                    array[i] = in.readObject();
                }
                return array;
            }
        };
    }

    public boolean isOverwritable() {
        return true;
    }
}

