/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.impl.serialization;

import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.Serializer;
import com.hazelcast.nio.serialization.SerializerHook;
import com.hazelcast.nio.serialization.StreamSerializer;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public final class HashMapHook
implements SerializerHook<HashMap> {
    public Class<HashMap> getSerializationType() {
        return HashMap.class;
    }

    public Serializer createSerializer() {
        return new StreamSerializer<HashMap>(){

            public int getTypeId() {
                return -322;
            }

            public void destroy() {
            }

            public void write(ObjectDataOutput out, HashMap map) throws IOException {
                out.writeInt(map.size());
                Iterator iterator = map.entrySet().iterator();
                while (iterator.hasNext()) {
                    Map.Entry o;
                    Map.Entry e = o = iterator.next();
                    out.writeObject(e.getKey());
                    out.writeObject(e.getValue());
                }
            }

            public HashMap read(ObjectDataInput in) throws IOException {
                int length = in.readInt();
                HashMap<Object, Object> map = new HashMap<Object, Object>();
                for (int i = 0; i < length; ++i) {
                    map.put(in.readObject(), in.readObject());
                }
                return map;
            }
        };
    }

    public boolean isOverwritable() {
        return true;
    }
}

