/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.impl.config;

import com.hazelcast.config.AbstractDomConfigProcessor;
import com.hazelcast.config.DomConfigHelper;
import com.hazelcast.config.InvalidConfigurationException;
import com.hazelcast.core.HazelcastException;
import com.hazelcast.jet.config.EdgeConfig;
import com.hazelcast.jet.config.InstanceConfig;
import com.hazelcast.jet.config.JetConfig;
import com.hazelcast.jet.config.MetricsConfig;
import com.hazelcast.jet.impl.config.JetConfigSections;
import java.util.Optional;
import org.w3c.dom.Node;

public class JetDomConfigProcessor
extends AbstractDomConfigProcessor {
    protected final JetConfig config;

    JetDomConfigProcessor(boolean domLevel3, JetConfig config) {
        super(domLevel3);
        this.config = config;
    }

    public void buildConfig(Node rootNode) {
        for (Node node : DomConfigHelper.childElements((Node)rootNode)) {
            String nodeName = DomConfigHelper.cleanNodeName((Node)node);
            if (this.occurrenceSet.contains(nodeName)) {
                throw new InvalidConfigurationException("Duplicate '" + nodeName + "' definition found in the configuration.");
            }
            if (this.handleNode(node, nodeName) || JetConfigSections.canOccurMultipleTimes(nodeName)) continue;
            this.occurrenceSet.add(nodeName);
        }
    }

    private boolean handleNode(Node node, String name) {
        if (JetConfigSections.INSTANCE.isEqual(name)) {
            this.parseInstanceConfig(node, this.config);
        } else {
            if (JetConfigSections.IMPORT.isEqual(name)) {
                throw new HazelcastException("Non-expanded <import> element found");
            }
            if (JetConfigSections.PROPERTIES.isEqual(name)) {
                this.fillProperties(node, this.config.getProperties());
            } else if (JetConfigSections.EDGE_DEFAULTS.isEqual(name)) {
                this.parseEdgeDefaults(node, this.config);
            } else if (JetConfigSections.METRICS.isEqual(name)) {
                this.parseMetrics(node, this.config);
            } else {
                return true;
            }
        }
        return false;
    }

    protected void parseInstanceConfig(Node instanceNode, JetConfig config) {
        InstanceConfig instanceConfig = config.getInstanceConfig();
        block14: for (Node node : DomConfigHelper.childElements((Node)instanceNode)) {
            String name;
            switch (name = DomConfigHelper.cleanNodeName((Node)node)) {
                case "cooperative-thread-count": {
                    instanceConfig.setCooperativeThreadCount(DomConfigHelper.getIntegerValue((String)"cooperative-thread-count", (String)this.getTextContent(node)));
                    continue block14;
                }
                case "flow-control-period": {
                    instanceConfig.setFlowControlPeriodMs(DomConfigHelper.getIntegerValue((String)"flow-control-period", (String)this.getTextContent(node)));
                    continue block14;
                }
                case "backup-count": {
                    instanceConfig.setBackupCount(DomConfigHelper.getIntegerValue((String)"backup-count", (String)this.getTextContent(node)));
                    continue block14;
                }
                case "scale-up-delay-millis": {
                    instanceConfig.setScaleUpDelayMillis(DomConfigHelper.getLongValue((String)"scale-up-delay-millis", (String)this.getTextContent(node)));
                    continue block14;
                }
                case "lossless-restart-enabled": {
                    instanceConfig.setLosslessRestartEnabled(DomConfigHelper.getBooleanValue((String)this.getTextContent(node)));
                    continue block14;
                }
            }
            throw new AssertionError((Object)("Unrecognized element: " + name));
        }
    }

    protected void parseEdgeDefaults(Node edgeNode, JetConfig config) {
        EdgeConfig edgeConfig = config.getDefaultEdgeConfig();
        block10: for (Node child : DomConfigHelper.childElements((Node)edgeNode)) {
            String name;
            switch (name = DomConfigHelper.cleanNodeName((Node)child)) {
                case "queue-size": {
                    edgeConfig.setQueueSize(DomConfigHelper.getIntegerValue((String)"queue-size", (String)this.getTextContent(child)));
                    continue block10;
                }
                case "packet-size-limit": {
                    edgeConfig.setPacketSizeLimit(DomConfigHelper.getIntegerValue((String)"packet-size-limit", (String)this.getTextContent(child)));
                    continue block10;
                }
                case "receive-window-multiplier": {
                    edgeConfig.setReceiveWindowMultiplier(DomConfigHelper.getIntegerValue((String)"receive-window-multiplier", (String)this.getTextContent(child)));
                    continue block10;
                }
            }
            throw new AssertionError((Object)("Unrecognized element: " + name));
        }
    }

    protected void parseMetrics(Node metricsNode, JetConfig config) {
        MetricsConfig metricsConfig = config.getMetricsConfig();
        this.getBooleanAttribute(metricsNode, "enabled").ifPresent(metricsConfig::setEnabled);
        this.getBooleanAttribute(metricsNode, "jmxEnabled").ifPresent(metricsConfig::setJmxEnabled);
        this.handleMetricsNode(metricsNode, metricsConfig);
    }

    protected void handleMetricsNode(Node metricsNode, MetricsConfig metricsConfig) {
        block13: for (Node child : DomConfigHelper.childElements((Node)metricsNode)) {
            String name;
            switch (name = DomConfigHelper.cleanNodeName((Node)child)) {
                case "retention-seconds": {
                    metricsConfig.setRetentionSeconds(DomConfigHelper.getIntegerValue((String)"retention-seconds", (String)this.getTextContent(child)));
                    continue block13;
                }
                case "collection-interval-seconds": {
                    metricsConfig.setCollectionIntervalSeconds(DomConfigHelper.getIntegerValue((String)"collection-interval-seconds", (String)this.getTextContent(child)));
                    continue block13;
                }
                case "metrics-for-data-structures": {
                    metricsConfig.setMetricsForDataStructuresEnabled(DomConfigHelper.getBooleanValue((String)this.getTextContent(child)));
                    continue block13;
                }
                case "enabled": 
                case "jmx-enabled": {
                    continue block13;
                }
            }
            throw new AssertionError((Object)("Unrecognized element: " + name));
        }
    }

    private Optional<Boolean> getBooleanAttribute(Node node, String name) {
        return Optional.ofNullable(node.getAttributes().getNamedItem(name)).map(n -> DomConfigHelper.getBooleanValue((String)this.getTextContent((Node)n)));
    }
}

