/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.impl.aggregate;

import com.hazelcast.jet.aggregate.AggregateOperation;
import com.hazelcast.jet.function.BiConsumerEx;
import com.hazelcast.jet.function.FunctionEx;
import com.hazelcast.jet.function.SupplierEx;
import com.hazelcast.jet.impl.util.Util;
import com.hazelcast.util.Preconditions;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class AggregateOperationImpl<A, R>
implements AggregateOperation<A, R> {
    final BiConsumerEx<? super A, ?>[] accumulateFns;
    private final SupplierEx<A> createFn;
    private final BiConsumerEx<? super A, ? super A> combineFn;
    private final BiConsumerEx<? super A, ? super A> deductFn;
    private final FunctionEx<? super A, ? extends R> exportFn;
    private final FunctionEx<? super A, ? extends R> finishFn;

    public AggregateOperationImpl(@Nonnull SupplierEx<A> createFn, @Nonnull BiConsumerEx<? super A, ?>[] accumulateFns, @Nullable BiConsumerEx<? super A, ? super A> combineFn, @Nullable BiConsumerEx<? super A, ? super A> deductFn, @Nonnull FunctionEx<? super A, ? extends R> exportFn, @Nonnull FunctionEx<? super A, ? extends R> finishFn) {
        for (BiConsumerEx<? super A, ?> f : accumulateFns) {
            Preconditions.checkNotNull(f, (String)"accumulateFns array contains a null slot");
        }
        this.createFn = createFn;
        this.accumulateFns = (BiConsumerEx[])accumulateFns.clone();
        this.combineFn = combineFn;
        this.deductFn = deductFn;
        this.exportFn = exportFn;
        this.finishFn = finishFn;
    }

    @Override
    public int arity() {
        return this.accumulateFns.length;
    }

    @Override
    @Nonnull
    public SupplierEx<A> createFn() {
        return this.createFn;
    }

    @Override
    @Nonnull
    public <T> BiConsumerEx<? super A, ? super T> accumulateFn(int index) {
        if (index >= this.accumulateFns.length) {
            throw new IllegalArgumentException("This AggregateOperation has " + this.accumulateFns.length + " accumulating functions, but was asked for function at index " + index);
        }
        return this.accumulateFns[index];
    }

    @Override
    @Nullable
    public BiConsumerEx<? super A, ? super A> combineFn() {
        return this.combineFn;
    }

    @Override
    @Nullable
    public BiConsumerEx<? super A, ? super A> deductFn() {
        return this.deductFn;
    }

    @Override
    @Nonnull
    public FunctionEx<? super A, ? extends R> exportFn() {
        return this.exportFn;
    }

    @Override
    @Nonnull
    public FunctionEx<? super A, ? extends R> finishFn() {
        return this.finishFn;
    }

    @Override
    @Nonnull
    public AggregateOperation<A, R> withAccumulateFns(BiConsumerEx ... accumulateFns) {
        return new AggregateOperationImpl<A, R>(this.createFn(), accumulateFns, this.combineFn(), this.deductFn(), this.exportFn(), this.finishFn());
    }

    @Override
    @Nonnull
    public AggregateOperation<A, A> withIdentityFinish() {
        Util.checkSerializable(this.finishFn, "finishFn");
        return new AggregateOperationImpl<A, A>(this.createFn(), this.accumulateFns, this.combineFn(), this.deductFn(), this.unsupportedExportFn(), FunctionEx.identity());
    }

    @Override
    @Nonnull
    public <R_NEW> AggregateOperation<A, R_NEW> andThen(FunctionEx<? super R, ? extends R_NEW> thenFn) {
        return new AggregateOperationImpl<A, R_NEW>(this.createFn(), this.accumulateFns, this.combineFn(), this.deductFn(), this.exportFn().andThen(thenFn), this.finishFn().andThen(thenFn));
    }

    @Nonnull
    static <A> BiConsumerEx<? super A, ?>[] accumulateFns(BiConsumerEx ... accFns) {
        return accFns;
    }

    FunctionEx<? super A, ? extends A> unsupportedExportFn() {
        return x -> {
            throw new UnsupportedOperationException("Can't use exportFn on an aggregate operation with identity finishFn");
        };
    }
}

