/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.impl;

import com.hazelcast.jet.core.JobStatus;
import com.hazelcast.jet.impl.execution.init.JetInitDataSerializerHook;
import com.hazelcast.jet.impl.util.Util;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.IdentifiedDataSerializable;
import java.io.IOException;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class JobSummary
implements IdentifiedDataSerializable {
    private long jobId;
    private long executionId;
    private String name;
    private JobStatus status;
    private long submissionTime;
    private long completionTime;
    private String failureText;

    public JobSummary() {
    }

    public JobSummary(long jobId, long executionId, @Nonnull String name, @Nonnull JobStatus status, long submissionTime) {
        this.jobId = jobId;
        this.executionId = executionId;
        this.name = name;
        this.status = status;
        this.submissionTime = submissionTime;
    }

    public JobSummary(long jobId, @Nonnull String name, @Nonnull JobStatus status, long submissionTime, long completionTime, @Nullable String failureText) {
        this.jobId = jobId;
        this.name = name;
        this.status = status;
        this.submissionTime = submissionTime;
        this.completionTime = completionTime;
        this.failureText = failureText;
    }

    public long getJobId() {
        return this.jobId;
    }

    public long getExecutionId() {
        return this.executionId;
    }

    @Nonnull
    public String getName() {
        return this.name;
    }

    @Nonnull
    public JobStatus getStatus() {
        return this.status;
    }

    public long getSubmissionTime() {
        return this.submissionTime;
    }

    public long getCompletionTime() {
        return this.completionTime;
    }

    @Nullable
    public String getFailureText() {
        return this.failureText;
    }

    public int getFactoryId() {
        return JetInitDataSerializerHook.FACTORY_ID;
    }

    public int getId() {
        return 32;
    }

    public void writeData(ObjectDataOutput out) throws IOException {
        out.writeLong(this.jobId);
        out.writeLong(this.executionId);
        out.writeUTF(this.name);
        out.writeObject((Object)this.status);
        out.writeLong(this.submissionTime);
        out.writeLong(this.completionTime);
        out.writeUTF(this.failureText);
    }

    public void readData(ObjectDataInput in) throws IOException {
        this.jobId = in.readLong();
        this.executionId = in.readLong();
        this.name = in.readUTF();
        this.status = (JobStatus)((Object)in.readObject());
        this.submissionTime = in.readLong();
        this.completionTime = in.readLong();
        this.failureText = in.readUTF();
    }

    public String toString() {
        return "JobSummary{jobId=" + com.hazelcast.jet.Util.idToString(this.jobId) + ", executionId=" + com.hazelcast.jet.Util.idToString(this.executionId) + ", name='" + this.name + '\'' + ", status=" + (Object)((Object)this.status) + ", submissionTime=" + Util.toLocalTime(this.submissionTime) + ", completionTime=" + Util.toLocalTime(this.completionTime) + ", failureText=" + this.failureText + '}';
    }
}

