/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.impl;

import com.hazelcast.client.impl.client.DistributedObjectInfo;
import com.hazelcast.client.impl.clientside.ClientMessageDecoder;
import com.hazelcast.client.impl.clientside.HazelcastClientInstanceImpl;
import com.hazelcast.client.impl.protocol.ClientMessage;
import com.hazelcast.client.impl.protocol.codec.ClientGetDistributedObjectsCodec;
import com.hazelcast.client.impl.protocol.codec.JetExistsDistributedObjectCodec;
import com.hazelcast.client.impl.protocol.codec.JetGetClusterMetadataCodec;
import com.hazelcast.client.impl.protocol.codec.JetGetJobIdsByNameCodec;
import com.hazelcast.client.impl.protocol.codec.JetGetJobIdsCodec;
import com.hazelcast.client.impl.protocol.codec.JetGetJobSummaryListCodec;
import com.hazelcast.client.impl.protocol.codec.JetGetMemberXmlConfigurationCodec;
import com.hazelcast.client.impl.protocol.codec.JetReadMetricsCodec;
import com.hazelcast.client.spi.impl.ClientInvocation;
import com.hazelcast.client.util.ClientDelegatingFuture;
import com.hazelcast.config.Config;
import com.hazelcast.config.InMemoryXmlConfig;
import com.hazelcast.core.Cluster;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.core.ICompletableFuture;
import com.hazelcast.core.Member;
import com.hazelcast.jet.Job;
import com.hazelcast.jet.config.JetConfig;
import com.hazelcast.jet.config.JobConfig;
import com.hazelcast.jet.core.DAG;
import com.hazelcast.jet.impl.AbstractJetInstance;
import com.hazelcast.jet.impl.ClientJobProxy;
import com.hazelcast.jet.impl.ClusterMetadata;
import com.hazelcast.jet.impl.JobSummary;
import com.hazelcast.jet.impl.metrics.management.ConcurrentArrayRingbuffer;
import com.hazelcast.jet.impl.metrics.management.MetricsResultSet;
import com.hazelcast.jet.impl.util.ExceptionUtil;
import com.hazelcast.logging.ILogger;
import com.hazelcast.nio.Address;
import com.hazelcast.spi.serialization.SerializationService;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;

public class JetClientInstanceImpl
extends AbstractJetInstance {
    private final HazelcastClientInstanceImpl client;
    private final SerializationService serializationService;
    private final ClientMessageDecoder decodeMetricsResponse = new ClientMessageDecoder(){

        public <T> T decodeClientMessage(ClientMessage msg) {
            ConcurrentArrayRingbuffer.RingbufferSlice deserialized = (ConcurrentArrayRingbuffer.RingbufferSlice)JetClientInstanceImpl.this.serializationService.toObject((Object)JetReadMetricsCodec.decodeResponse((ClientMessage)msg).response);
            return (T)new MetricsResultSet(deserialized);
        }
    };

    public JetClientInstanceImpl(HazelcastClientInstanceImpl hazelcastInstance) {
        super((HazelcastInstance)hazelcastInstance);
        this.client = hazelcastInstance;
        this.serializationService = this.client.getSerializationService();
        ExceptionUtil.registerJetExceptions(hazelcastInstance.getClientExceptionFactory());
    }

    @Override
    @Nonnull
    public JetConfig getConfig() {
        throw new UnsupportedOperationException("Jet Configuration is not available on the client");
    }

    @Override
    @Nonnull
    public List<Job> getJobs() {
        ClientInvocation invocation = new ClientInvocation(this.client, JetGetJobIdsCodec.encodeRequest(), null, JetClientInstanceImpl.masterAddress(this.client.getCluster()));
        try {
            ClientMessage response = (ClientMessage)invocation.invoke().get();
            List jobs = JetGetJobIdsCodec.decodeResponse((ClientMessage)response).response;
            return jobs.stream().map(jobId -> new ClientJobProxy(this, (long)jobId)).collect(Collectors.toList());
        }
        catch (Throwable t) {
            throw ExceptionUtil.rethrow(t);
        }
    }

    @Nonnull
    public ICompletableFuture<MetricsResultSet> readMetricsAsync(Member member, long startSequence) {
        ClientMessage request = JetReadMetricsCodec.encodeRequest((String)member.getUuid(), (long)startSequence);
        ClientInvocation invocation = new ClientInvocation(this.client, request, null, member.getAddress());
        return new ClientDelegatingFuture(invocation.invoke(), this.serializationService, this.decodeMetricsResponse, false);
    }

    @Nonnull
    public List<JobSummary> getJobSummaryList() {
        return (List)this.invokeRequestOnMasterAndDecodeResponse(JetGetJobSummaryListCodec.encodeRequest(), response -> JetGetJobSummaryListCodec.decodeResponse((ClientMessage)response).response);
    }

    @Nonnull
    public ClusterMetadata getClusterMetadata() {
        return (ClusterMetadata)this.invokeRequestOnMasterAndDecodeResponse(JetGetClusterMetadataCodec.encodeRequest(), response -> {
            JetGetClusterMetadataCodec.ResponseParameters parameters = JetGetClusterMetadataCodec.decodeResponse((ClientMessage)response);
            ClusterMetadata metadata = new ClusterMetadata();
            metadata.setClusterTime(parameters.clusterTime);
            metadata.setName(parameters.name);
            metadata.setState(parameters.state);
            metadata.setVersion(parameters.version);
            return metadata;
        });
    }

    @Nonnull
    public Config getHazelcastConfig() {
        String configString = (String)this.invokeRequestOnMasterAndDecodeResponse(JetGetMemberXmlConfigurationCodec.encodeRequest(), response -> JetGetMemberXmlConfigurationCodec.decodeResponse((ClientMessage)response).response);
        return new InMemoryXmlConfig(configString);
    }

    @Nonnull
    public HazelcastClientInstanceImpl getHazelcastClient() {
        return this.client;
    }

    @Override
    public boolean existsDistributedObject(@Nonnull String serviceName, @Nonnull String objectName) {
        return (Boolean)this.invokeRequestOnAnyMemberAndDecodeResponse(JetExistsDistributedObjectCodec.encodeRequest((String)serviceName, (String)objectName), response -> JetExistsDistributedObjectCodec.decodeResponse((ClientMessage)response).response);
    }

    public List<DistributedObjectInfo> getDistributedObjects() {
        return (List)this.invokeRequestOnAnyMemberAndDecodeResponse(ClientGetDistributedObjectsCodec.encodeRequest(), response -> ClientGetDistributedObjectsCodec.decodeResponse((ClientMessage)response).response);
    }

    @Override
    public List<Long> getJobIdsByName(String name) {
        return (List)this.invokeRequestOnMasterAndDecodeResponse(JetGetJobIdsByNameCodec.encodeRequest((String)name), response -> JetGetJobIdsByNameCodec.decodeResponse((ClientMessage)response).response);
    }

    @Override
    public Job newJobProxy(long jobId, DAG dag, JobConfig config) {
        return new ClientJobProxy(this, jobId, dag, config);
    }

    @Override
    public Job newJobProxy(long jobId) {
        return new ClientJobProxy(this, jobId);
    }

    @Override
    public ILogger getLogger() {
        return this.client.getLoggingService().getLogger(this.getClass());
    }

    private <S> S invokeRequestOnMasterAndDecodeResponse(ClientMessage request, Function<ClientMessage, Object> decoder) {
        return this.invokeRequestAndDecodeResponse(JetClientInstanceImpl.masterAddress(this.client.getCluster()), request, decoder);
    }

    private <S> S invokeRequestOnAnyMemberAndDecodeResponse(ClientMessage request, Function<ClientMessage, Object> decoder) {
        return this.invokeRequestAndDecodeResponse(null, request, decoder);
    }

    private <S> S invokeRequestAndDecodeResponse(Address address, ClientMessage request, Function<ClientMessage, Object> decoder) {
        ClientInvocation invocation = new ClientInvocation(this.client, request, null, address);
        try {
            ClientMessage response = (ClientMessage)invocation.invoke().get();
            return (S)this.serializationService.toObject(decoder.apply(response));
        }
        catch (Throwable t) {
            throw ExceptionUtil.rethrow(t);
        }
    }

    private static Address masterAddress(Cluster cluster) {
        return ((Member)cluster.getMembers().stream().findFirst().orElseThrow(() -> new IllegalStateException("No members found in cluster"))).getAddress();
    }
}

