/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.config;

import com.hazelcast.util.Preconditions;
import java.io.Serializable;
import java.net.URL;
import javax.annotation.Nonnull;

public class ResourceConfig
implements Serializable {
    private final URL url;
    private final String id;
    private final boolean isArchive;

    ResourceConfig(@Nonnull URL url, String id, boolean isArchive) {
        Preconditions.checkTrue((boolean)(isArchive ^ id != null), (String)"Either isArchive == true, or id != null, exclusively");
        this.url = url;
        this.id = id;
        this.isArchive = isArchive;
    }

    ResourceConfig(Class clazz) {
        this.id = clazz.getName().replace('.', '/') + ".class";
        this.url = clazz.getClassLoader().getResource(this.id);
        Preconditions.checkNotNull((Object)this.url, (String)("Couldn't derive URL from class " + clazz));
        this.isArchive = false;
    }

    public URL getUrl() {
        return this.url;
    }

    public String getId() {
        return this.id;
    }

    public boolean isArchive() {
        return this.isArchive;
    }

    public String toString() {
        return "ResourceConfig{url=" + this.url + ", id='" + this.id + '\'' + ", isArchive=" + this.isArchive + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ResourceConfig that = (ResourceConfig)o;
        if (this.isArchive != that.isArchive) {
            return false;
        }
        if (this.url != null ? !this.url.toString().equals(that.url.toString()) : that.url != null) {
            return false;
        }
        return this.id != null ? this.id.equals(that.id) : that.id == null;
    }

    public int hashCode() {
        int result = this.url != null ? this.url.toString().hashCode() : 0;
        result = 31 * result + (this.id != null ? this.id.hashCode() : 0);
        result = 31 * result + (this.isArchive ? 1 : 0);
        return result;
    }
}

