/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.config;

import com.hazelcast.jet.config.JetConfigDataSerializerHook;
import com.hazelcast.jet.config.JobClassLoaderFactory;
import com.hazelcast.jet.config.ProcessingGuarantee;
import com.hazelcast.jet.config.ResourceConfig;
import com.hazelcast.jet.impl.util.ExceptionUtil;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.IdentifiedDataSerializable;
import com.hazelcast.util.Preconditions;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class JobConfig
implements IdentifiedDataSerializable {
    private static final long SNAPSHOT_INTERVAL_MILLIS_DEFAULT = TimeUnit.SECONDS.toMillis(10L);
    private String name;
    private ProcessingGuarantee processingGuarantee = ProcessingGuarantee.NONE;
    private long snapshotIntervalMillis = SNAPSHOT_INTERVAL_MILLIS_DEFAULT;
    private boolean autoScaling = true;
    private boolean splitBrainProtectionEnabled;
    private boolean enableMetrics = true;
    private boolean storeMetricsAfterJobCompletion;
    private List<ResourceConfig> resourceConfigs = new ArrayList<ResourceConfig>();
    private JobClassLoaderFactory classLoaderFactory;
    private String initialSnapshotName;

    @Nullable
    public String getName() {
        return this.name;
    }

    @Nonnull
    public JobConfig setName(@Nullable String name) {
        this.name = name;
        return this;
    }

    public boolean isSplitBrainProtectionEnabled() {
        return this.splitBrainProtectionEnabled;
    }

    @Nonnull
    public JobConfig setSplitBrainProtection(boolean isEnabled) {
        this.splitBrainProtectionEnabled = isEnabled;
        return this;
    }

    public JobConfig setAutoScaling(boolean enabled) {
        this.autoScaling = enabled;
        return this;
    }

    public boolean isAutoScaling() {
        return this.autoScaling;
    }

    @Nonnull
    public ProcessingGuarantee getProcessingGuarantee() {
        return this.processingGuarantee;
    }

    @Nonnull
    public JobConfig setProcessingGuarantee(@Nonnull ProcessingGuarantee processingGuarantee) {
        this.processingGuarantee = processingGuarantee;
        return this;
    }

    public long getSnapshotIntervalMillis() {
        return this.snapshotIntervalMillis;
    }

    @Nonnull
    public JobConfig setSnapshotIntervalMillis(long snapshotInterval) {
        Preconditions.checkNotNegative((long)snapshotInterval, (String)"snapshotInterval can't be negative");
        this.snapshotIntervalMillis = snapshotInterval;
        return this;
    }

    @Nonnull
    public JobConfig addClass(Class ... classes) {
        Preconditions.checkNotNull((Object)classes, (String)"Classes can not be null");
        for (Class clazz : classes) {
            this.resourceConfigs.add(new ResourceConfig(clazz));
        }
        return this;
    }

    @Nonnull
    public JobConfig addJar(@Nonnull URL url) {
        return this.add(url, null, true);
    }

    @Nonnull
    public JobConfig addJar(@Nonnull File file) {
        try {
            return this.addJar(file.toURI().toURL());
        }
        catch (MalformedURLException e) {
            throw ExceptionUtil.rethrow(e);
        }
    }

    @Nonnull
    public JobConfig addJar(@Nonnull String path) {
        try {
            File file = new File(path);
            return this.addJar(file.toURI().toURL());
        }
        catch (MalformedURLException e) {
            throw ExceptionUtil.rethrow(e);
        }
    }

    @Nonnull
    public JobConfig addResource(@Nonnull URL url) {
        return this.addResource(url, JobConfig.toFilename(url));
    }

    @Nonnull
    public JobConfig addResource(@Nonnull URL url, @Nonnull String id) {
        return this.add(url, id, false);
    }

    @Nonnull
    public JobConfig addResource(@Nonnull File file) {
        try {
            return this.addResource(file.toURI().toURL(), file.getName());
        }
        catch (MalformedURLException e) {
            throw ExceptionUtil.rethrow(e);
        }
    }

    @Nonnull
    public JobConfig addResource(@Nonnull File file, @Nonnull String id) {
        try {
            return this.add(file.toURI().toURL(), id, false);
        }
        catch (MalformedURLException e) {
            throw ExceptionUtil.rethrow(e);
        }
    }

    @Nonnull
    public JobConfig addResource(@Nonnull String path) {
        return this.addResource(new File(path));
    }

    @Nonnull
    public JobConfig addResource(@Nonnull String path, @Nonnull String id) {
        return this.addResource(new File(path), id);
    }

    @Nonnull
    public List<ResourceConfig> getResourceConfigs() {
        return this.resourceConfigs;
    }

    private JobConfig add(URL url, String id, boolean isJar) {
        this.resourceConfigs.add(new ResourceConfig(url, id, isJar));
        return this;
    }

    private static String toFilename(URL url) {
        String urlFile = url.getPath();
        return urlFile.substring(urlFile.lastIndexOf(47) + 1);
    }

    @Nonnull
    public JobConfig setClassLoaderFactory(@Nullable JobClassLoaderFactory classLoaderFactory) {
        this.classLoaderFactory = classLoaderFactory;
        return this;
    }

    @Nullable
    public JobClassLoaderFactory getClassLoaderFactory() {
        return this.classLoaderFactory;
    }

    @Nullable
    public String getInitialSnapshotName() {
        return this.initialSnapshotName;
    }

    @Nonnull
    public JobConfig setInitialSnapshotName(@Nullable String initialSnapshotName) {
        this.initialSnapshotName = initialSnapshotName;
        return this;
    }

    @Nonnull
    public JobConfig setMetricsEnabled(boolean enabled) {
        this.enableMetrics = enabled;
        return this;
    }

    public boolean isMetricsEnabled() {
        return this.enableMetrics;
    }

    public boolean isStoreMetricsAfterJobCompletion() {
        return this.storeMetricsAfterJobCompletion;
    }

    public JobConfig setStoreMetricsAfterJobCompletion(boolean storeMetricsAfterJobCompletion) {
        this.storeMetricsAfterJobCompletion = storeMetricsAfterJobCompletion;
        return this;
    }

    public int getFactoryId() {
        return JetConfigDataSerializerHook.FACTORY_ID;
    }

    public int getId() {
        return 0;
    }

    public void writeData(ObjectDataOutput out) throws IOException {
        out.writeUTF(this.name);
        out.writeObject((Object)this.processingGuarantee);
        out.writeLong(this.snapshotIntervalMillis);
        out.writeBoolean(this.autoScaling);
        out.writeBoolean(this.splitBrainProtectionEnabled);
        out.writeObject(this.resourceConfigs);
        out.writeObject((Object)this.classLoaderFactory);
        out.writeUTF(this.initialSnapshotName);
        out.writeBoolean(this.enableMetrics);
        out.writeBoolean(this.storeMetricsAfterJobCompletion);
    }

    public void readData(ObjectDataInput in) throws IOException {
        this.name = in.readUTF();
        this.processingGuarantee = (ProcessingGuarantee)((Object)in.readObject());
        this.snapshotIntervalMillis = in.readLong();
        this.autoScaling = in.readBoolean();
        this.splitBrainProtectionEnabled = in.readBoolean();
        this.resourceConfigs = (List)in.readObject();
        this.classLoaderFactory = (JobClassLoaderFactory)in.readObject();
        this.initialSnapshotName = in.readUTF();
        this.enableMetrics = in.readBoolean();
        this.storeMetricsAfterJobCompletion = in.readBoolean();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        JobConfig jobConfig = (JobConfig)o;
        return this.snapshotIntervalMillis == jobConfig.snapshotIntervalMillis && this.autoScaling == jobConfig.autoScaling && this.splitBrainProtectionEnabled == jobConfig.splitBrainProtectionEnabled && this.enableMetrics == jobConfig.enableMetrics && this.storeMetricsAfterJobCompletion == jobConfig.storeMetricsAfterJobCompletion && Objects.equals(this.name, jobConfig.name) && this.processingGuarantee == jobConfig.processingGuarantee && Objects.equals(this.resourceConfigs, jobConfig.resourceConfigs) && Objects.equals(this.classLoaderFactory, jobConfig.classLoaderFactory) && Objects.equals(this.initialSnapshotName, jobConfig.initialSnapshotName);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.name, this.processingGuarantee, this.snapshotIntervalMillis, this.autoScaling, this.splitBrainProtectionEnabled, this.enableMetrics, this.storeMetricsAfterJobCompletion, this.resourceConfigs, this.classLoaderFactory, this.initialSnapshotName});
    }
}

