/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.pipeline;

import com.hazelcast.jet.JetInstance;
import com.hazelcast.jet.function.ConsumerEx;
import com.hazelcast.jet.function.FunctionEx;
import com.hazelcast.jet.impl.util.Util;
import com.hazelcast.util.Preconditions;
import java.io.Serializable;
import javax.annotation.Nonnull;

public final class ContextFactory<C>
implements Serializable {
    public static final int MAX_PENDING_CALLS_DEFAULT = 256;
    public static final boolean COOPERATIVE_DEFAULT = true;
    public static final boolean SHARE_LOCALLY_DEFAULT = false;
    public static final boolean ORDERED_ASYNC_RESPONSES_DEFAULT = true;
    private final FunctionEx<JetInstance, ? extends C> createFn;
    private final ConsumerEx<? super C> destroyFn;
    private final boolean isCooperative;
    private final boolean hasLocalSharing;
    private final int maxPendingCallsPerProcessor;
    private final boolean orderedAsyncResponses;

    private ContextFactory(FunctionEx<JetInstance, ? extends C> createFn, ConsumerEx<? super C> destroyFn, boolean isCooperative, boolean hasLocalSharing, int maxPendingCallsPerProcessor, boolean orderedAsyncResponses) {
        this.createFn = createFn;
        this.destroyFn = destroyFn;
        this.isCooperative = isCooperative;
        this.hasLocalSharing = hasLocalSharing;
        this.maxPendingCallsPerProcessor = maxPendingCallsPerProcessor;
        this.orderedAsyncResponses = orderedAsyncResponses;
    }

    @Nonnull
    public static <C> ContextFactory<C> withCreateFn(@Nonnull FunctionEx<JetInstance, ? extends C> createContextFn) {
        Util.checkSerializable(createContextFn, "createContextFn");
        return new ContextFactory<C>(createContextFn, ConsumerEx.noop(), true, false, 256, true);
    }

    @Nonnull
    public ContextFactory<C> withDestroyFn(@Nonnull ConsumerEx<? super C> destroyFn) {
        Util.checkSerializable(destroyFn, "destroyFn");
        return new ContextFactory<C>(this.createFn, destroyFn, this.isCooperative, this.hasLocalSharing, this.maxPendingCallsPerProcessor, this.orderedAsyncResponses);
    }

    @Nonnull
    public ContextFactory<C> toNonCooperative() {
        return new ContextFactory<C>(this.createFn, this.destroyFn, false, this.hasLocalSharing, this.maxPendingCallsPerProcessor, this.orderedAsyncResponses);
    }

    @Nonnull
    public ContextFactory<C> withLocalSharing() {
        return new ContextFactory<C>(this.createFn, this.destroyFn, this.isCooperative, true, this.maxPendingCallsPerProcessor, this.orderedAsyncResponses);
    }

    @Nonnull
    public ContextFactory<C> withMaxPendingCallsPerProcessor(int maxPendingCallsPerProcessor) {
        Preconditions.checkPositive((int)maxPendingCallsPerProcessor, (String)"maxPendingCallsPerProcessor must be >= 1");
        return new ContextFactory<C>(this.createFn, this.destroyFn, this.isCooperative, this.hasLocalSharing, maxPendingCallsPerProcessor, this.orderedAsyncResponses);
    }

    @Nonnull
    public ContextFactory<C> withUnorderedAsyncResponses() {
        return new ContextFactory<C>(this.createFn, this.destroyFn, this.isCooperative, this.hasLocalSharing, this.maxPendingCallsPerProcessor, false);
    }

    @Nonnull
    public FunctionEx<JetInstance, ? extends C> createFn() {
        return this.createFn;
    }

    @Nonnull
    public ConsumerEx<? super C> destroyFn() {
        return this.destroyFn;
    }

    public boolean isCooperative() {
        return this.isCooperative;
    }

    public boolean hasLocalSharing() {
        return this.hasLocalSharing;
    }

    public int maxPendingCallsPerProcessor() {
        return this.maxPendingCallsPerProcessor;
    }

    public boolean hasOrderedAsyncResponses() {
        return this.orderedAsyncResponses;
    }
}

