/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.impl.serialization;

import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.Serializer;
import com.hazelcast.nio.serialization.SerializerHook;
import com.hazelcast.nio.serialization.StreamSerializer;
import java.io.IOException;
import java.util.HashSet;

public final class HashSetHook
implements SerializerHook<HashSet> {
    public Class<HashSet> getSerializationType() {
        return HashSet.class;
    }

    public Serializer createSerializer() {
        return new StreamSerializer<HashSet>(){

            public int getTypeId() {
                return -323;
            }

            public void destroy() {
            }

            public void write(ObjectDataOutput out, HashSet set) throws IOException {
                out.writeInt(set.size());
                for (Object o : set) {
                    out.writeObject(o);
                }
            }

            public HashSet read(ObjectDataInput in) throws IOException {
                int length = in.readInt();
                HashSet<Object> set = new HashSet<Object>();
                for (int i = 0; i < length; ++i) {
                    set.add(in.readObject());
                }
                return set;
            }
        };
    }

    public boolean isOverwritable() {
        return true;
    }
}

