/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.impl.pipeline.transform;

import com.hazelcast.jet.Traverser;
import com.hazelcast.jet.core.processor.Processors;
import com.hazelcast.jet.function.FunctionEx;
import com.hazelcast.jet.function.ToLongFunctionEx;
import com.hazelcast.jet.function.TriFunction;
import com.hazelcast.jet.impl.pipeline.Planner;
import com.hazelcast.jet.impl.pipeline.transform.StatefulKeyedTransformBase;
import com.hazelcast.jet.impl.pipeline.transform.Transform;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class FlatMapStatefulTransform<T, K, S, R>
extends StatefulKeyedTransformBase<T, K, S> {
    private final TriFunction<? super S, ? super K, ? super T, ? extends Traverser<R>> statefulFlatMapFn;
    private final TriFunction<? super S, ? super K, ? super Long, ? extends Traverser<R>> onEvictFn;

    public FlatMapStatefulTransform(@Nonnull Transform upstream, long ttl, @Nonnull FunctionEx<? super T, ? extends K> keyFn, @Nonnull ToLongFunctionEx<? super T> timestampFn, @Nonnull Supplier<? extends S> createFn, @Nonnull TriFunction<? super S, ? super K, ? super T, ? extends Traverser<R>> flatMapFn, @Nullable TriFunction<? super S, ? super K, ? super Long, ? extends Traverser<R>> onEvictFn) {
        super("flatmap-stateful-keyed", upstream, ttl, keyFn, timestampFn, createFn);
        this.statefulFlatMapFn = flatMapFn;
        this.onEvictFn = onEvictFn;
    }

    @Override
    public void addToDag(Planner p) {
        Planner.PlannerVertex pv = p.addVertex((Transform)this, this.name(), this.localParallelism(), Processors.flatMapStatefulP(this.ttl, this.keyFn, this.timestampFn, this.createFn, this.statefulFlatMapFn, this.onEvictFn));
        p.addEdges((Transform)this, pv.v, edge -> edge.partitioned(this.keyFn).distributed());
    }
}

