/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.impl.pipeline;

import com.hazelcast.jet.Traverser;
import com.hazelcast.jet.aggregate.AggregateOperation;
import com.hazelcast.jet.aggregate.AggregateOperation1;
import com.hazelcast.jet.aggregate.AggregateOperation2;
import com.hazelcast.jet.aggregate.AggregateOperation3;
import com.hazelcast.jet.function.BiConsumerEx;
import com.hazelcast.jet.function.BiFunctionEx;
import com.hazelcast.jet.function.BiPredicateEx;
import com.hazelcast.jet.function.FunctionEx;
import com.hazelcast.jet.function.PredicateEx;
import com.hazelcast.jet.function.ToLongFunctionEx;
import com.hazelcast.jet.function.TriFunction;
import com.hazelcast.jet.impl.JetEvent;
import com.hazelcast.jet.impl.pipeline.FunctionAdapter;
import com.hazelcast.jet.pipeline.JoinClause;
import java.util.Arrays;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Nonnull;

class JetEventFunctionAdapter
extends FunctionAdapter {
    JetEventFunctionAdapter() {
    }

    @Nonnull
    public <T, K> FunctionEx<? super JetEvent<T>, ? extends K> adaptKeyFn(@Nonnull FunctionEx<? super T, ? extends K> keyFn) {
        return e -> keyFn.apply((Object)e.payload());
    }

    @Nonnull
    <T> ToLongFunctionEx<? super JetEvent<T>> adaptTimestampFn() {
        return JetEvent::timestamp;
    }

    @Nonnull
    <T, R> FunctionEx<? super JetEvent<T>, ?> adaptMapFn(@Nonnull FunctionEx<? super T, ? extends R> mapFn) {
        return e -> JetEvent.jetEvent(e.timestamp(), mapFn.apply((Object)e.payload()));
    }

    @Nonnull
    <T> PredicateEx<? super JetEvent<T>> adaptFilterFn(@Nonnull PredicateEx<? super T> filterFn) {
        return e -> filterFn.test((Object)e.payload());
    }

    @Nonnull
    <T, R> FunctionEx<? super JetEvent<T>, ? extends Traverser<JetEvent<R>>> adaptFlatMapFn(@Nonnull FunctionEx<? super T, ? extends Traverser<? extends R>> flatMapFn) {
        return e -> ((Traverser)flatMapFn.apply((Object)e.payload())).map(r -> JetEvent.jetEvent(e.timestamp(), r));
    }

    @Nonnull
    <S, K, T, R> TriFunction<? super S, ? super K, ? super JetEvent<T>, ? extends JetEvent<R>> adaptStatefulMapFn(@Nonnull TriFunction<? super S, ? super K, ? super T, ? extends R> mapFn) {
        return (state, key, e) -> JetEvent.jetEvent(e.timestamp(), mapFn.apply((Object)state, (Object)key, (Object)e.payload()));
    }

    @Nonnull
    <S, K, R> TriFunction<? super S, ? super K, ? super Long, ? extends JetEvent<R>> adaptOnEvictFn(@Nonnull TriFunction<? super S, ? super K, ? super Long, ? extends R> onEvictFn) {
        return (s, k, wm) -> JetEvent.jetEvent(wm, onEvictFn.apply((Object)s, (Object)k, (Long)wm));
    }

    @Nonnull
    <S, K, T, R> TriFunction<? super S, ? super K, ? super JetEvent<T>, ? extends Traverser<JetEvent<R>>> adaptStatefulFlatMapFn(@Nonnull TriFunction<? super S, ? super K, ? super T, ? extends Traverser<R>> flatMapFn) {
        return (state, key, e) -> ((Traverser)flatMapFn.apply((Object)state, (Object)key, (Object)e.payload())).map(r -> JetEvent.jetEvent(e.timestamp(), r));
    }

    @Nonnull
    <S, K, R> TriFunction<? super S, ? super K, ? super Long, ? extends Traverser<JetEvent<R>>> adaptOnEvictFlatMapFn(@Nonnull TriFunction<? super S, ? super K, ? super Long, ? extends Traverser<R>> onEvictFn) {
        return (s, k, wm) -> ((Traverser)onEvictFn.apply((Object)s, (Object)k, (Long)wm)).map(r -> JetEvent.jetEvent(wm, r));
    }

    @Nonnull
    <C, T, R> BiFunctionEx<? super C, ? super JetEvent<T>, ? extends JetEvent<R>> adaptMapUsingContextFn(@Nonnull BiFunctionEx<? super C, ? super T, ? extends R> mapFn) {
        return (context, e) -> JetEvent.jetEvent(e.timestamp(), mapFn.apply((Object)context, (Object)e.payload()));
    }

    @Nonnull
    <C, T> BiPredicateEx<? super C, ? super JetEvent<T>> adaptFilterUsingContextFn(@Nonnull BiPredicateEx<? super C, ? super T> filterFn) {
        return (context, e) -> filterFn.test((Object)context, (Object)e.payload());
    }

    @Nonnull
    <C, T, R> BiFunctionEx<? super C, ? super JetEvent<T>, ? extends Traverser<JetEvent<R>>> adaptFlatMapUsingContextFn(@Nonnull BiFunctionEx<? super C, ? super T, ? extends Traverser<? extends R>> flatMapFn) {
        return (context, e) -> ((Traverser)flatMapFn.apply((Object)context, (Object)e.payload())).map(r -> JetEvent.jetEvent(e.timestamp(), r));
    }

    @Override
    @Nonnull
    <C, T, R> BiFunctionEx<? super C, ?, ? extends CompletableFuture<Traverser<?>>> adaptFlatMapUsingContextAsyncFn(@Nonnull BiFunctionEx<? super C, ? super T, ? extends CompletableFuture<Traverser<R>>> flatMapAsyncFn) {
        return (context, e) -> ((CompletableFuture)flatMapAsyncFn.apply((Object)context, (Object)e.payload())).thenApply(trav -> trav.map(re -> JetEvent.jetEvent(e.timestamp(), re)));
    }

    @Nonnull
    <T, STR extends CharSequence> FunctionEx<? super JetEvent<T>, ? extends STR> adaptToStringFn(@Nonnull FunctionEx<? super T, ? extends STR> toStringFn) {
        return e -> (CharSequence)toStringFn.apply((Object)e.payload());
    }

    @Nonnull
    public <K, T0, T1, T1_OUT> JoinClause<? extends K, ? super JetEvent<T0>, ? super T1, ? extends T1_OUT> adaptJoinClause(@Nonnull JoinClause<? extends K, ? super T0, ? super T1, ? extends T1_OUT> joinClause) {
        return JoinClause.onKeys(this.adaptKeyFn(joinClause.leftKeyFn()), joinClause.rightKeyFn()).projecting(joinClause.rightProjectFn());
    }

    @Nonnull
    public <T, T1, R> BiFunctionEx<? super JetEvent<T>, ? super T1, ?> adaptHashJoinOutputFn(@Nonnull BiFunctionEx<? super T, ? super T1, ? extends R> mapToOutputFn) {
        return (e, t1) -> JetEvent.jetEvent(e.timestamp(), mapToOutputFn.apply((Object)e.payload(), (Object)t1));
    }

    @Nonnull
    <T, T1, T2, R> TriFunction<? super JetEvent<T>, ? super T1, ? super T2, ?> adaptHashJoinOutputFn(@Nonnull TriFunction<? super T, ? super T1, ? super T2, ? extends R> mapToOutputFn) {
        return (e, t1, t2) -> JetEvent.jetEvent(e.timestamp(), mapToOutputFn.apply((Object)e.payload(), (Object)t1, (Object)t2));
    }

    @Override
    @Nonnull
    <A, R> AggregateOperation<A, ? extends R> adaptAggregateOperation(@Nonnull AggregateOperation<A, ? extends R> aggrOp) {
        if (aggrOp instanceof AggregateOperation1) {
            return this.adaptAggregateOperation1((AggregateOperation1)aggrOp);
        }
        if (aggrOp instanceof AggregateOperation2) {
            return JetEventFunctionAdapter.adaptAggregateOperation2((AggregateOperation2)aggrOp);
        }
        if (aggrOp instanceof AggregateOperation3) {
            return JetEventFunctionAdapter.adaptAggregateOperation3((AggregateOperation3)aggrOp);
        }
        BiConsumerEx[] adaptedAccFns = new BiConsumerEx[aggrOp.arity()];
        Arrays.setAll(adaptedAccFns, i -> JetEventFunctionAdapter.adaptAccumulateFn(aggrOp.accumulateFn(i)));
        return aggrOp.withAccumulateFns(adaptedAccFns);
    }

    @Nonnull
    <T, A, R> AggregateOperation1<? super JetEvent<T>, A, ? extends R> adaptAggregateOperation1(@Nonnull AggregateOperation1<? super T, A, ? extends R> aggrOp) {
        return aggrOp.withAccumulateFn(JetEventFunctionAdapter.adaptAccumulateFn(aggrOp.accumulateFn()));
    }

    @Nonnull
    static <T0, T1, A, R> AggregateOperation2<? super JetEvent<T0>, ? super JetEvent<T1>, A, ? extends R> adaptAggregateOperation2(@Nonnull AggregateOperation2<? super T0, ? super T1, A, ? extends R> aggrOp) {
        return aggrOp.withAccumulateFn0(JetEventFunctionAdapter.adaptAccumulateFn(aggrOp.accumulateFn0())).withAccumulateFn1(JetEventFunctionAdapter.adaptAccumulateFn(aggrOp.accumulateFn1()));
    }

    @Nonnull
    static <T0, T1, T2, A, R> AggregateOperation3<? super JetEvent<T0>, ? super JetEvent<T1>, ? super JetEvent<T2>, A, ? extends R> adaptAggregateOperation3(@Nonnull AggregateOperation3<? super T0, ? super T1, ? super T2, A, ? extends R> aggrOp) {
        return aggrOp.withAccumulateFn0(JetEventFunctionAdapter.adaptAccumulateFn(aggrOp.accumulateFn0())).withAccumulateFn1(JetEventFunctionAdapter.adaptAccumulateFn(aggrOp.accumulateFn1())).withAccumulateFn2(JetEventFunctionAdapter.adaptAccumulateFn(aggrOp.accumulateFn2()));
    }

    @Nonnull
    private static <A, T> BiConsumerEx<? super A, ? super JetEvent<T>> adaptAccumulateFn(@Nonnull BiConsumerEx<? super A, ? super T> accumulateFn) {
        return (acc, t) -> accumulateFn.accept((Object)acc, (Object)t.payload());
    }
}

