/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.impl.connector;

import com.hazelcast.cache.ICache;
import com.hazelcast.client.config.ClientConfig;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.core.HazelcastInstanceNotActiveException;
import com.hazelcast.core.IList;
import com.hazelcast.jet.RestartableException;
import com.hazelcast.jet.core.Processor;
import com.hazelcast.jet.core.ProcessorMetaSupplier;
import com.hazelcast.jet.function.BiConsumerEx;
import com.hazelcast.jet.function.BiFunctionEx;
import com.hazelcast.jet.function.BinaryOperatorEx;
import com.hazelcast.jet.function.ConsumerEx;
import com.hazelcast.jet.function.FunctionEx;
import com.hazelcast.jet.function.SupplierEx;
import com.hazelcast.jet.impl.connector.AbstractHazelcastConnectorSupplier;
import com.hazelcast.jet.impl.connector.UpdateMapP;
import com.hazelcast.jet.impl.connector.UpdateMapWithEntryProcessorP;
import com.hazelcast.jet.impl.connector.WriteBufferedP;
import com.hazelcast.jet.impl.connector.WriteMapP;
import com.hazelcast.jet.impl.util.ImdgUtil;
import com.hazelcast.jet.impl.util.Util;
import com.hazelcast.map.EntryProcessor;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public final class HazelcastWriters {
    private HazelcastWriters() {
    }

    @Nonnull
    public static <K, V> ProcessorMetaSupplier writeMapSupplier(@Nonnull String name, @Nullable ClientConfig clientConfig) {
        return ProcessorMetaSupplier.of(new WriteMapP.Supplier(ImdgUtil.asXmlString(clientConfig), name));
    }

    @Nonnull
    public static <T, K, V> ProcessorMetaSupplier mergeMapSupplier(@Nonnull String name, @Nullable ClientConfig clientConfig, @Nonnull FunctionEx<? super T, ? extends K> toKeyFn, @Nonnull FunctionEx<? super T, ? extends V> toValueFn, @Nonnull BinaryOperatorEx<V> mergeFn) {
        Util.checkSerializable(toKeyFn, "toKeyFn");
        Util.checkSerializable(toValueFn, "toValueFn");
        Util.checkSerializable(mergeFn, "mergeFn");
        return HazelcastWriters.updateMapSupplier(name, clientConfig, toKeyFn, (? super V oldValue, ? super T item) -> {
            Object newValue = toValueFn.apply(item);
            if (oldValue == null) {
                return newValue;
            }
            return mergeFn.apply((Object)oldValue, (Object)newValue);
        });
    }

    @Nonnull
    public static <T, K, V> ProcessorMetaSupplier updateMapSupplier(@Nonnull String mapName, @Nullable ClientConfig clientConfig, @Nonnull FunctionEx<? super T, ? extends K> toKeyFn, @Nonnull BiFunctionEx<? super V, ? super T, ? extends V> updateFn) {
        Util.checkSerializable(toKeyFn, "toKeyFn");
        Util.checkSerializable(updateFn, "updateFn");
        return ProcessorMetaSupplier.of(new UpdateMapP.Supplier<T, K, V>(ImdgUtil.asXmlString(clientConfig), mapName, toKeyFn, updateFn));
    }

    @Nonnull
    public static <T, K, V> ProcessorMetaSupplier updateMapSupplier(@Nonnull String name, @Nullable ClientConfig clientConfig, @Nonnull FunctionEx<? super T, ? extends K> toKeyFn, @Nonnull FunctionEx<? super T, ? extends EntryProcessor<K, V>> toEntryProcessorFn) {
        Util.checkSerializable(toKeyFn, "toKeyFn");
        Util.checkSerializable(toEntryProcessorFn, "toEntryProcessorFn");
        return ProcessorMetaSupplier.of(new UpdateMapWithEntryProcessorP.Supplier(name, ImdgUtil.asXmlString(clientConfig), toKeyFn, toEntryProcessorFn));
    }

    @Nonnull
    public static <K, V> ProcessorMetaSupplier writeCacheSupplier(@Nonnull String name, @Nullable ClientConfig clientConfig) {
        boolean isLocal = clientConfig == null;
        return ProcessorMetaSupplier.of(2, new WriterSupplier<ArrayMap, Map.Entry>(ImdgUtil.asXmlString(clientConfig), ArrayMap::new, ArrayMap::add, CacheFlush.flushToCache(name, isLocal), ConsumerEx.noop()));
    }

    @Nonnull
    public static ProcessorMetaSupplier writeListSupplier(@Nonnull String name, @Nullable ClientConfig clientConfig) {
        boolean isLocal = clientConfig == null;
        return ProcessorMetaSupplier.preferLocalParallelismOne(new WriterSupplier<ArrayList, Object>(ImdgUtil.asXmlString(clientConfig), ArrayList::new, ArrayList::add, instance -> {
            IList list = instance.getList(name);
            return buffer -> {
                try {
                    list.addAll((Collection)buffer);
                }
                catch (HazelcastInstanceNotActiveException e) {
                    throw HazelcastWriters.handleInstanceNotActive(e, isLocal);
                }
                buffer.clear();
            };
        }, ConsumerEx.noop()));
    }

    static RuntimeException handleInstanceNotActive(HazelcastInstanceNotActiveException e, boolean isLocal) {
        return isLocal ? new RestartableException(e) : e;
    }

    private static class WriterSupplier<B, T>
    extends AbstractHazelcastConnectorSupplier {
        static final long serialVersionUID = 1L;
        private final FunctionEx<HazelcastInstance, ConsumerEx<B>> instanceToFlushBufferFn;
        private final SupplierEx<B> newBufferFn;
        private final BiConsumerEx<B, T> addToBufferFn;
        private final ConsumerEx<B> disposeBufferFn;

        WriterSupplier(String clientXml, SupplierEx<B> newBufferFn, BiConsumerEx<B, T> addToBufferFn, FunctionEx<HazelcastInstance, ConsumerEx<B>> instanceToFlushBufferFn, ConsumerEx<B> disposeBufferFn) {
            super(clientXml);
            this.newBufferFn = newBufferFn;
            this.addToBufferFn = addToBufferFn;
            this.instanceToFlushBufferFn = instanceToFlushBufferFn;
            this.disposeBufferFn = disposeBufferFn;
        }

        @Override
        protected Processor createProcessor(HazelcastInstance instance) {
            ConsumerEx<B> flushBufferFn = this.instanceToFlushBufferFn.apply(instance);
            return new WriteBufferedP<Object, T>(ctx -> this.newBufferFn.get(), this.addToBufferFn, flushBufferFn, this.disposeBufferFn);
        }
    }

    static final class ArrayMap<K, V>
    extends AbstractMap<K, V> {
        private final List<Map.Entry<K, V>> entries;
        private final ArraySet set = new ArraySet();

        ArrayMap() {
            this.entries = new ArrayList<Map.Entry<K, V>>();
        }

        ArrayMap(int size) {
            this.entries = new ArrayList<Map.Entry<K, V>>(size);
        }

        @Override
        @Nonnull
        public Set<Map.Entry<K, V>> entrySet() {
            return this.set;
        }

        public void add(Map.Entry<K, V> entry) {
            this.entries.add(entry);
        }

        @Override
        public V get(Object key) {
            throw new UnsupportedOperationException();
        }

        @Override
        public String toString() {
            return this.entries.toString();
        }

        private class ArraySet
        extends AbstractSet<Map.Entry<K, V>> {
            private ArraySet() {
            }

            @Override
            @Nonnull
            public Iterator<Map.Entry<K, V>> iterator() {
                return ArrayMap.this.entries.iterator();
            }

            @Override
            public int size() {
                return ArrayMap.this.entries.size();
            }

            @Override
            public void clear() {
                ArrayMap.this.entries.clear();
            }
        }
    }

    private static class CacheFlush {
        private CacheFlush() {
        }

        static <K, V> FunctionEx<HazelcastInstance, ConsumerEx<ArrayMap<K, V>>> flushToCache(String name, boolean isLocal) {
            return instance -> {
                ICache cache = instance.getCacheManager().getCache(name);
                return buffer -> {
                    try {
                        cache.putAll((Map)buffer);
                    }
                    catch (HazelcastInstanceNotActiveException e) {
                        throw HazelcastWriters.handleInstanceNotActive(e, isLocal);
                    }
                    buffer.clear();
                };
            };
        }
    }
}

