/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.impl.aggregate;

import com.hazelcast.aggregation.Aggregator;
import com.hazelcast.jet.aggregate.AggregateOperation1;
import com.hazelcast.jet.impl.execution.init.JetInitDataSerializerHook;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.IdentifiedDataSerializable;
import java.io.IOException;
import java.util.Objects;

public class AggregateOpAggregator<T, A, R>
extends Aggregator<T, R>
implements IdentifiedDataSerializable {
    private AggregateOperation1<? super T, A, ? extends R> aggrOp;
    private A accumulator;

    public AggregateOpAggregator() {
    }

    public AggregateOpAggregator(AggregateOperation1<? super T, A, ? extends R> aggrOp) {
        Objects.requireNonNull(aggrOp.combineFn(), "The supplied AggregateOperation doesn't have the combineFn, which is required for an Aggregator");
        this.aggrOp = aggrOp;
        this.accumulator = aggrOp.createFn().get();
    }

    public void accumulate(T input) {
        this.aggrOp.accumulateFn().accept(this.accumulator, input);
    }

    public void combine(Aggregator aggregator) {
        AggregateOpAggregator other = (AggregateOpAggregator)aggregator;
        this.aggrOp.combineFn().accept(this.accumulator, other.accumulator);
    }

    public R aggregate() {
        return this.aggrOp.finishFn().apply(this.accumulator);
    }

    public int getFactoryId() {
        return JetInitDataSerializerHook.FACTORY_ID;
    }

    public int getId() {
        return 38;
    }

    public void writeData(ObjectDataOutput out) throws IOException {
        out.writeObject(this.aggrOp);
        out.writeObject(this.accumulator);
    }

    public void readData(ObjectDataInput in) throws IOException {
        this.aggrOp = (AggregateOperation1)in.readObject();
        this.accumulator = in.readObject();
    }
}

