/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.impl;

import com.hazelcast.jet.config.JobConfig;
import com.hazelcast.jet.impl.execution.init.JetInitDataSerializerHook;
import com.hazelcast.jet.impl.util.Util;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.nio.serialization.IdentifiedDataSerializable;
import java.io.IOException;

public class JobRecord
implements IdentifiedDataSerializable {
    private long jobId;
    private long creationTime;
    private Data dag;
    private String dagJson;
    private JobConfig config;

    public JobRecord() {
    }

    public JobRecord(long jobId, long creationTime, Data dag, String dagJson, JobConfig config) {
        this.jobId = jobId;
        this.creationTime = creationTime;
        this.dag = dag;
        this.dagJson = dagJson;
        this.config = config;
    }

    public long getJobId() {
        return this.jobId;
    }

    public String getJobNameOrId() {
        return this.config.getName() != null ? this.config.getName() : com.hazelcast.jet.Util.idToString(this.jobId);
    }

    public long getCreationTime() {
        return this.creationTime;
    }

    public Data getDag() {
        return this.dag;
    }

    public String getDagJson() {
        return this.dagJson;
    }

    public JobConfig getConfig() {
        return this.config;
    }

    public int getFactoryId() {
        return JetInitDataSerializerHook.FACTORY_ID;
    }

    public int getId() {
        return 3;
    }

    public void writeData(ObjectDataOutput out) throws IOException {
        out.writeLong(this.jobId);
        out.writeLong(this.creationTime);
        out.writeData(this.dag);
        out.writeUTF(this.dagJson);
        out.writeObject((Object)this.config);
    }

    public void readData(ObjectDataInput in) throws IOException {
        this.jobId = in.readLong();
        this.creationTime = in.readLong();
        this.dag = in.readData();
        this.dagJson = in.readUTF();
        this.config = (JobConfig)in.readObject();
    }

    public String toString() {
        return "JobRecord{jobId=" + com.hazelcast.jet.Util.idToString(this.jobId) + ", name=" + this.getConfig().getName() + ", creationTime=" + Util.toLocalDateTime(this.creationTime) + ", dagJson=" + this.dagJson + ", config=" + this.config + '}';
    }
}

