/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.core.metrics;

import com.hazelcast.jet.core.metrics.MetricsDataSerializerHook;
import com.hazelcast.jet.impl.util.Util;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.IdentifiedDataSerializable;
import java.io.IOException;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class Measurement
implements IdentifiedDataSerializable {
    private Map<String, String> tags;
    private long value;
    private long timestamp;

    Measurement() {
    }

    private Measurement(long value, long timestamp, @Nonnull Map<String, String> tags) {
        this.value = value;
        this.timestamp = timestamp;
        this.tags = new HashMap<String, String>(tags);
    }

    @Nonnull
    public static Measurement of(long value, long timestamp, @Nonnull Map<String, String> tags) {
        Objects.requireNonNull(tags, "tags");
        return new Measurement(value, timestamp, tags);
    }

    public long getValue() {
        return this.value;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    @Nullable
    public String getTag(String name) {
        return this.tags.get(name);
    }

    public int getFactoryId() {
        return MetricsDataSerializerHook.FACTORY_ID;
    }

    public int getId() {
        return 1;
    }

    public void writeData(ObjectDataOutput out) throws IOException {
        out.writeObject(this.tags);
        out.writeLong(this.value);
        out.writeLong(this.timestamp);
    }

    public void readData(ObjectDataInput in) throws IOException {
        this.tags = (Map)in.readObject();
        this.value = in.readLong();
        this.timestamp = in.readLong();
    }

    public int hashCode() {
        return 31 * (int)(this.timestamp * 31L + this.value) + Objects.hashCode(this.tags);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object obj) {
        if (this == obj) return true;
        if (!(obj instanceof Measurement)) return false;
        Measurement that = (Measurement)obj;
        if (this.timestamp != that.timestamp) return false;
        if (this.value != that.value) return false;
        if (!Objects.equals(this.tags, that.tags)) return false;
        return true;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(String.format("%,5d", this.value)).append(" ").append(Util.toLocalTime(this.timestamp)).append(" [");
        String tags = this.tags.entrySet().stream().sorted(Comparator.comparing(Map.Entry::getKey)).map(e -> (String)e.getKey() + "=" + (String)e.getValue()).collect(Collectors.joining(", "));
        sb.append(tags).append(']');
        return sb.toString();
    }
}

