/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.pipeline;

import com.hazelcast.jet.pipeline.WindowDefinition;
import com.hazelcast.util.Preconditions;

public class SlidingWindowDefinition
extends WindowDefinition {
    private final long windowSize;
    private final long slideBy;

    SlidingWindowDefinition(long windowSize, long slideBy) {
        Preconditions.checkPositive((long)windowSize, (String)"windowSize must be positive");
        Preconditions.checkPositive((long)slideBy, (String)"slideBy must be positive");
        Preconditions.checkTrue((windowSize % slideBy == 0L ? 1 : 0) != 0, (String)("windowSize must be integer multiple of slideBy, mod(" + windowSize + ", " + slideBy + ") != 0"));
        this.windowSize = windowSize;
        this.slideBy = slideBy;
    }

    @Override
    public SlidingWindowDefinition setEarlyResultsPeriod(long earlyResultPeriod) {
        return (SlidingWindowDefinition)super.setEarlyResultsPeriod(earlyResultPeriod);
    }

    public long windowSize() {
        return this.windowSize;
    }

    public long slideBy() {
        return this.slideBy;
    }
}

