/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.pipeline;

import com.hazelcast.jet.core.processor.SourceProcessors;
import com.hazelcast.jet.function.ConsumerEx;
import com.hazelcast.jet.function.FunctionEx;
import com.hazelcast.jet.function.SupplierEx;
import com.hazelcast.jet.impl.util.Util;
import com.hazelcast.jet.pipeline.Sources;
import com.hazelcast.jet.pipeline.StreamSource;
import com.hazelcast.util.Preconditions;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.jms.Connection;
import javax.jms.ConnectionFactory;
import javax.jms.Destination;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.Session;

public final class JmsSourceBuilder {
    private final SupplierEx<? extends ConnectionFactory> factorySupplier;
    private final boolean isTopic;
    private FunctionEx<? super ConnectionFactory, ? extends Connection> connectionFn;
    private FunctionEx<? super Connection, ? extends Session> sessionFn;
    private FunctionEx<? super Session, ? extends MessageConsumer> consumerFn;
    private ConsumerEx<? super Session> flushFn;
    private String username;
    private String password;
    private boolean transacted;
    private int acknowledgeMode = 1;
    private String destinationName;

    JmsSourceBuilder(SupplierEx<? extends ConnectionFactory> factorySupplier, boolean isTopic) {
        Util.checkSerializable(factorySupplier, "factorySupplier");
        this.factorySupplier = factorySupplier;
        this.isTopic = isTopic;
    }

    public JmsSourceBuilder connectionParams(String username, String password) {
        this.username = username;
        this.password = password;
        return this;
    }

    public JmsSourceBuilder connectionFn(@Nonnull FunctionEx<? super ConnectionFactory, ? extends Connection> connectionFn) {
        Util.checkSerializable(connectionFn, "connectionFn");
        this.connectionFn = connectionFn;
        return this;
    }

    public JmsSourceBuilder sessionParams(boolean transacted, int acknowledgeMode) {
        this.transacted = transacted;
        this.acknowledgeMode = acknowledgeMode;
        return this;
    }

    public JmsSourceBuilder sessionFn(@Nonnull FunctionEx<? super Connection, ? extends Session> sessionFn) {
        Util.checkSerializable(sessionFn, "sessionFn");
        this.sessionFn = sessionFn;
        return this;
    }

    public JmsSourceBuilder destinationName(String destinationName) {
        this.destinationName = destinationName;
        return this;
    }

    public JmsSourceBuilder consumerFn(@Nonnull FunctionEx<? super Session, ? extends MessageConsumer> consumerFn) {
        Util.checkSerializable(consumerFn, "consumerFn");
        this.consumerFn = consumerFn;
        return this;
    }

    public JmsSourceBuilder flushFn(@Nonnull ConsumerEx<? super Session> flushFn) {
        Util.checkSerializable(flushFn, "flushFn");
        this.flushFn = flushFn;
        return this;
    }

    public <T> StreamSource<T> build(@Nonnull FunctionEx<? super Message, ? extends T> projectionFn) {
        String usernameLocal = this.username;
        String passwordLocal = this.password;
        boolean transactedLocal = this.transacted;
        int acknowledgeModeLocal = this.acknowledgeMode;
        String nameLocal = this.destinationName;
        boolean isTopicLocal = this.isTopic;
        if (this.connectionFn == null) {
            this.connectionFn = factory -> factory.createConnection(usernameLocal, passwordLocal);
        }
        if (this.sessionFn == null) {
            this.sessionFn = connection -> connection.createSession(transactedLocal, acknowledgeModeLocal);
        }
        if (this.consumerFn == null) {
            Preconditions.checkNotNull((Object)nameLocal);
            this.consumerFn = session -> session.createConsumer((Destination)(isTopicLocal ? session.createTopic(nameLocal) : session.createQueue(nameLocal)));
        }
        if (this.flushFn == null) {
            this.flushFn = ConsumerEx.noop();
        }
        FunctionEx<? super ConnectionFactory, ? extends Connection> connectionFnLocal = this.connectionFn;
        SupplierEx<? extends ConnectionFactory> factorySupplierLocal = this.factorySupplier;
        SupplierEx<Connection> newConnectionFn = () -> (Connection)connectionFnLocal.apply((ConnectionFactory)factorySupplierLocal.get());
        Function metaSupplierFactory = policy -> this.isTopic ? SourceProcessors.streamJmsTopicP(newConnectionFn, this.sessionFn, this.consumerFn, this.flushFn, projectionFn, policy) : SourceProcessors.streamJmsQueueP(newConnectionFn, this.sessionFn, this.consumerFn, this.flushFn, projectionFn, policy);
        return Sources.streamFromProcessorWithWatermarks(this.sourceName(), metaSupplierFactory, true);
    }

    public StreamSource<Message> build() {
        return this.build(message -> message);
    }

    private String sourceName() {
        return (this.isTopic ? "jmsTopicSource(" : "jmsQueueSource(") + (this.destinationName == null ? "?" : this.destinationName) + ')';
    }
}

