/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.impl.metrics;

import com.hazelcast.internal.metrics.MetricsUtil;
import com.hazelcast.jet.impl.metrics.Metric;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Iterator;
import java.util.zip.Deflater;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.InflaterInputStream;

public class MetricsCompressor {
    private static final int INITIAL_BUFFER_SIZE = 4096;
    private static final int SIZE_FACTOR_NUMERATOR = 11;
    private static final int SIZE_FACTOR_DENOMINATOR = 10;
    private static final int BITS_IN_BYTE = 8;
    private static final int BYTE_MASK = 255;
    private static final short SHORT_BITS = 16;
    private static final int CONVERSION_PRECISION = 4;
    private static final double DOUBLE_TO_LONG = Math.pow(10.0, 4.0);
    private static final short BINARY_FORMAT_VERSION = 1;
    private DataOutputStream dos;
    private MorePublicByteArrayOutputStream baos = new MorePublicByteArrayOutputStream(4096);
    private String lastName;
    private int count;

    public MetricsCompressor() {
        this.reset(4096);
    }

    public void addLong(String name, long value) {
        try {
            this.writeName(name);
            this.dos.writeLong(value);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void addDouble(String name, double value) {
        try {
            this.writeName(name);
            this.dos.writeLong(Math.round(value * DOUBLE_TO_LONG));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public byte[] getBlobAndReset() {
        byte[] blob = this.getRenderedBlob();
        this.reset(blob.length * 11 / 10);
        return blob;
    }

    public int count() {
        return this.count;
    }

    private void writeName(String name) throws IOException {
        int equalPrefixLength;
        if (!name.startsWith("[") || !name.endsWith("]")) {
            name = "[metric=" + MetricsUtil.escapeMetricNamePart((String)name) + ']';
        }
        if (name.length() >= 65536) {
            throw new RuntimeException("metric name too long: " + name);
        }
        int shorterLen = Math.min(name.length(), this.lastName.length());
        for (equalPrefixLength = 0; equalPrefixLength < shorterLen && name.charAt(equalPrefixLength) == this.lastName.charAt(equalPrefixLength); ++equalPrefixLength) {
        }
        this.dos.writeShort(equalPrefixLength);
        this.dos.writeUTF(name.substring(equalPrefixLength));
        this.lastName = name;
        ++this.count;
    }

    private void reset(int estimatedBytes) {
        Deflater compressor = new Deflater();
        compressor.setLevel(1);
        if (this.baos.capacity() > Math.multiplyExact(estimatedBytes, 3) / 2) {
            this.baos = new MorePublicByteArrayOutputStream(estimatedBytes);
        }
        this.baos.reset();
        this.baos.write(0);
        this.baos.write(1);
        this.dos = new DataOutputStream(new DeflaterOutputStream((OutputStream)this.baos, compressor));
        this.count = 0;
        this.lastName = "";
    }

    private byte[] getRenderedBlob() {
        try {
            this.dos.close();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return this.baos.toByteArray();
    }

    public static Iterator<Metric> decompressingIterator(byte[] bytes) {
        ByteArrayInputStream bais = new ByteArrayInputStream(bytes);
        int version = (bais.read() << 8) + bais.read();
        if (version != 1) {
            throw new RuntimeException("Incorrect format, expected version 1, got " + version);
        }
        final DataInputStream dis = new DataInputStream(new InflaterInputStream(bais));
        return new Iterator<Metric>(){
            String lastName = "";
            Metric next;
            {
                this.moveNext();
            }

            @Override
            public boolean hasNext() {
                return this.next != null;
            }

            @Override
            public Metric next() {
                try {
                    Metric metric = this.next;
                    return metric;
                }
                finally {
                    this.moveNext();
                }
            }

            private void moveNext() {
                try {
                    int equalPrefixLen;
                    try {
                        equalPrefixLen = dis.readUnsignedShort();
                    }
                    catch (EOFException ignored) {
                        this.next = null;
                        dis.close();
                        return;
                    }
                    this.lastName = this.lastName.substring(0, equalPrefixLen) + dis.readUTF();
                    this.next = new Metric(this.lastName, dis.readLong());
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
        };
    }

    private static class MorePublicByteArrayOutputStream
    extends ByteArrayOutputStream {
        MorePublicByteArrayOutputStream(int size) {
            super(size);
        }

        int capacity() {
            return this.buf.length;
        }
    }
}

