/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.impl.metrics;

import com.hazelcast.config.Config;
import com.hazelcast.internal.diagnostics.Diagnostics;
import com.hazelcast.internal.metrics.ProbeLevel;
import com.hazelcast.internal.metrics.renderers.ProbeRenderer;
import com.hazelcast.jet.Util;
import com.hazelcast.jet.config.MetricsConfig;
import com.hazelcast.jet.impl.JobExecutionService;
import com.hazelcast.jet.impl.LiveOperationRegistry;
import com.hazelcast.jet.impl.metrics.JobMetricsPublisher;
import com.hazelcast.jet.impl.metrics.MetricsPublisher;
import com.hazelcast.jet.impl.metrics.jmx.JmxPublisher;
import com.hazelcast.jet.impl.metrics.management.ConcurrentArrayRingbuffer;
import com.hazelcast.jet.impl.metrics.management.ManagementCenterPublisher;
import com.hazelcast.jet.impl.util.ExceptionUtil;
import com.hazelcast.logging.ILogger;
import com.hazelcast.spi.LiveOperations;
import com.hazelcast.spi.LiveOperationsTracker;
import com.hazelcast.spi.NodeEngine;
import com.hazelcast.spi.impl.NodeEngineImpl;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;

public class JetMetricsService
implements LiveOperationsTracker {
    private final NodeEngineImpl nodeEngine;
    private final ILogger logger;
    private final LiveOperationRegistry liveOperationRegistry;
    private final ConcurrentMap<CompletableFuture<ConcurrentArrayRingbuffer.RingbufferSlice<Map.Entry<Long, byte[]>>>, Long> pendingReads = new ConcurrentHashMap<CompletableFuture<ConcurrentArrayRingbuffer.RingbufferSlice<Map.Entry<Long, byte[]>>>, Long>();
    private ConcurrentArrayRingbuffer<Map.Entry<Long, byte[]>> metricsJournal;
    private MetricsConfig config;
    private volatile ScheduledFuture<?> scheduledFuture;
    private List<MetricsPublisher> publishers;

    public JetMetricsService(NodeEngine nodeEngine) {
        this.nodeEngine = (NodeEngineImpl)nodeEngine;
        this.logger = nodeEngine.getLogger(this.getClass());
        this.liveOperationRegistry = new LiveOperationRegistry();
    }

    public static void applyMetricsConfig(Config hzConfig, MetricsConfig metricsConfig) {
        if (metricsConfig.isEnabled()) {
            hzConfig.setProperty(Diagnostics.METRICS_LEVEL.getName(), ProbeLevel.INFO.name());
            if (metricsConfig.isMetricsForDataStructuresEnabled()) {
                hzConfig.setProperty(Diagnostics.METRICS_DISTRIBUTED_DATASTRUCTURES.getName(), "true");
            }
        }
    }

    public void init(NodeEngine nodeEngine, JobExecutionService jobExecutionService, MetricsConfig config) {
        this.config = config;
        this.publishers = this.getPublishers(nodeEngine, jobExecutionService);
        if (this.publishers.isEmpty()) {
            return;
        }
        this.logger.info("Configuring metrics collection, collection interval=" + config.getCollectionIntervalSeconds() + " seconds, retention=" + config.getRetentionSeconds() + " seconds, publishers=" + this.publishers.stream().map(MetricsPublisher::name).collect(Collectors.joining(", ", "[", "]")));
        PublisherProbeRenderer renderer = new PublisherProbeRenderer();
        this.scheduledFuture = nodeEngine.getExecutionService().scheduleWithRepetition("MetricsPublisher", () -> {
            this.nodeEngine.getMetricsRegistry().render(renderer);
            for (MetricsPublisher publisher : this.publishers) {
                try {
                    publisher.whenComplete();
                }
                catch (Exception e) {
                    this.logger.severe("Error completing publication for publisher " + publisher, (Throwable)e);
                }
            }
        }, 1L, (long)config.getCollectionIntervalSeconds(), TimeUnit.SECONDS);
    }

    public boolean isEnabled() {
        return this.config.isEnabled();
    }

    public LiveOperationRegistry getLiveOperationRegistry() {
        return this.liveOperationRegistry;
    }

    public void populate(LiveOperations liveOperations) {
        this.liveOperationRegistry.populate(liveOperations);
    }

    public CompletableFuture<ConcurrentArrayRingbuffer.RingbufferSlice<Map.Entry<Long, byte[]>>> readMetrics(long startSequence) {
        if (!this.config.isEnabled()) {
            throw new IllegalArgumentException("Metrics collection is not enabled");
        }
        CompletableFuture<ConcurrentArrayRingbuffer.RingbufferSlice<Map.Entry<Long, byte[]>>> future = new CompletableFuture<ConcurrentArrayRingbuffer.RingbufferSlice<Map.Entry<Long, byte[]>>>();
        future.whenComplete(ExceptionUtil.withTryCatch(this.logger, (s, e) -> {
            Long cfr_ignored_0 = (Long)this.pendingReads.remove(future);
        }));
        this.pendingReads.put(future, startSequence);
        this.tryCompleteRead(future, startSequence);
        return future;
    }

    private void tryCompleteRead(CompletableFuture<ConcurrentArrayRingbuffer.RingbufferSlice<Map.Entry<Long, byte[]>>> future, long sequence) {
        try {
            ConcurrentArrayRingbuffer.RingbufferSlice<Map.Entry<Long, byte[]>> slice = this.metricsJournal.copyFrom(sequence);
            if (!slice.isEmpty()) {
                future.complete(slice);
            }
        }
        catch (Exception e) {
            this.logger.severe("Error reading from metrics journal, sequence: " + sequence, (Throwable)e);
            future.completeExceptionally(e);
        }
    }

    public void reset() {
    }

    public void shutdown() {
        if (this.scheduledFuture != null) {
            this.scheduledFuture.cancel(false);
        }
        for (MetricsPublisher publisher : this.publishers) {
            try {
                publisher.shutdown();
            }
            catch (Exception e) {
                this.logger.warning("Error shutting down metrics publisher " + publisher.name(), (Throwable)e);
            }
        }
    }

    private List<MetricsPublisher> getPublishers(NodeEngine nodeEngine, JobExecutionService jobExecutionService) {
        ArrayList<MetricsPublisher> publishers = new ArrayList<MetricsPublisher>();
        if (this.config.isEnabled()) {
            int journalSize = Math.max(1, (int)Math.ceil((double)this.config.getRetentionSeconds() / (double)this.config.getCollectionIntervalSeconds()));
            this.metricsJournal = new ConcurrentArrayRingbuffer(journalSize);
            publishers.add(new ManagementCenterPublisher(this.nodeEngine.getLoggingService(), (blob, ts) -> {
                this.metricsJournal.add(Util.entry(ts, blob));
                this.pendingReads.forEach(this::tryCompleteRead);
            }));
            publishers.add(new JobMetricsPublisher(jobExecutionService, nodeEngine.getLocalMember()));
            if (this.config.isJmxEnabled()) {
                publishers.add(new JmxPublisher(nodeEngine.getHazelcastInstance().getName(), "com.hazelcast"));
            }
        }
        return publishers;
    }

    private class PublisherProbeRenderer
    implements ProbeRenderer {
        private PublisherProbeRenderer() {
        }

        public void renderLong(String name, long value) {
            for (MetricsPublisher publisher : JetMetricsService.this.publishers) {
                try {
                    publisher.publishLong(name, value);
                }
                catch (Exception e) {
                    this.logError(name, value, publisher, e);
                }
            }
        }

        public void renderDouble(String name, double value) {
            for (MetricsPublisher publisher : JetMetricsService.this.publishers) {
                try {
                    publisher.publishDouble(name, value);
                }
                catch (Exception e) {
                    this.logError(name, value, publisher, e);
                }
            }
        }

        public void renderException(String name, Exception e) {
            JetMetricsService.this.logger.warning("Error when rendering '" + name + '\'', (Throwable)e);
        }

        public void renderNoValue(String name) {
        }

        private void logError(String name, Object value, MetricsPublisher publisher, Exception e) {
            JetMetricsService.this.logger.fine("Error publishing metric to: " + publisher.name() + ", metric=" + name + ", value=" + value, (Throwable)e);
        }
    }
}

