/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.impl;

import com.hazelcast.aggregation.Aggregators;
import com.hazelcast.core.IMap;
import com.hazelcast.jet.JetException;
import com.hazelcast.jet.impl.SnapshotValidationRecord;
import com.hazelcast.jet.impl.util.AsyncSnapshotWriterImpl;
import com.hazelcast.query.Predicate;
import java.io.Serializable;

final class SnapshotValidator {
    private SnapshotValidator() {
    }

    static long validateSnapshot(long snapshotId, IMap<Object, Object> snapshotMap, String jobIdString, String snapshotName) {
        SnapshotValidationRecord validationRecord = (SnapshotValidationRecord)snapshotMap.get((Object)SnapshotValidationRecord.KEY);
        if (validationRecord == null) {
            String nameOrId = snapshotName != null ? '\"' + snapshotName + '\"' : "with ID " + snapshotId;
            throw new JetException(String.format("snapshot %s doesn't exist or is damaged. Unable to restore the state for %s.", nameOrId, jobIdString));
        }
        if (validationRecord.numChunks() != (long)(snapshotMap.size() - 1)) {
            long filteredCount = (Long)snapshotMap.aggregate(Aggregators.count(), (Predicate & Serializable)e -> e.getKey() instanceof AsyncSnapshotWriterImpl.SnapshotDataKey && ((AsyncSnapshotWriterImpl.SnapshotDataKey)e.getKey()).snapshotId() == snapshotId);
            if (validationRecord.numChunks() != filteredCount) {
                throw new JetException(String.format("State for %s in IMap '%s' is corrupted: it should have %,d entries, but has %,d", jobIdString, snapshotMap.getName(), validationRecord.numChunks(), snapshotMap.size() - 1));
            }
        }
        if (snapshotId != -1L && snapshotId != validationRecord.snapshotId()) {
            throw new JetException(String.format("%s: IMap '%s' was supposed to contain snapshotId %d, but it contains snapshotId %d", jobIdString, snapshotMap.getName(), snapshotId, validationRecord.snapshotId()));
        }
        return validationRecord.snapshotId();
    }
}

