/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.impl;

import com.hazelcast.jet.JetException;
import com.hazelcast.jet.config.JobConfig;
import com.hazelcast.jet.core.JobStatus;
import com.hazelcast.jet.impl.execution.init.JetInitDataSerializerHook;
import com.hazelcast.jet.impl.util.Util;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.IdentifiedDataSerializable;
import java.io.IOException;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class JobResult
implements IdentifiedDataSerializable {
    private String coordinatorUUID;
    private long jobId;
    private JobConfig jobConfig;
    private long creationTime;
    private long completionTime;
    private String failureText;

    public JobResult() {
    }

    JobResult(long jobId, @Nonnull JobConfig jobConfig, @Nonnull String coordinatorUUID, long creationTime, long completionTime, @Nullable String failureText) {
        this.jobId = jobId;
        this.jobConfig = jobConfig;
        this.coordinatorUUID = coordinatorUUID;
        this.creationTime = creationTime;
        this.completionTime = completionTime;
        this.failureText = failureText;
    }

    public long getJobId() {
        return this.jobId;
    }

    @Nonnull
    public JobConfig getJobConfig() {
        return this.jobConfig;
    }

    @Nonnull
    public String getCoordinatorUUID() {
        return this.coordinatorUUID;
    }

    public long getCreationTime() {
        return this.creationTime;
    }

    public long getCompletionTime() {
        return this.completionTime;
    }

    public boolean isSuccessful() {
        return this.failureText == null;
    }

    @Nullable
    public String getFailureText() {
        return this.failureText;
    }

    @Nullable
    public Throwable getFailureAsThrowable() {
        Object throwable;
        if (this.failureText == null) {
            return null;
        }
        if (this.failureText.startsWith(CancellationException.class.getName())) {
            int prefixLength = (CancellationException.class.getName() + ": ").length();
            String message = this.failureText.length() >= prefixLength ? this.failureText.substring(prefixLength) : null;
            throwable = new CancellationException(message);
        } else {
            throwable = new JetException(this.failureText);
        }
        return throwable;
    }

    @Nonnull
    public JobStatus getJobStatus() {
        return this.isSuccessful() ? JobStatus.COMPLETED : JobStatus.FAILED;
    }

    @Nonnull
    CompletableFuture<Void> asCompletableFuture() {
        return this.failureText == null ? CompletableFuture.completedFuture(null) : Util.exceptionallyCompletedFuture(this.getFailureAsThrowable());
    }

    @Nonnull
    public String getJobNameOrId() {
        return this.jobConfig.getName() != null ? this.jobConfig.getName() : com.hazelcast.jet.Util.idToString(this.jobId);
    }

    public String toString() {
        return "JobResult{coordinatorUUID='" + this.coordinatorUUID + '\'' + ", jobId=" + com.hazelcast.jet.Util.idToString(this.jobId) + ", name=" + this.jobConfig.getName() + ", creationTime=" + Util.toLocalDateTime(this.creationTime) + ", completionTime=" + Util.toLocalDateTime(this.completionTime) + ", failureText=" + this.failureText + '}';
    }

    public int getFactoryId() {
        return JetInitDataSerializerHook.FACTORY_ID;
    }

    public int getId() {
        return 4;
    }

    public void writeData(ObjectDataOutput out) throws IOException {
        out.writeLong(this.jobId);
        out.writeObject((Object)this.jobConfig);
        out.writeUTF(this.coordinatorUUID);
        out.writeLong(this.creationTime);
        out.writeLong(this.completionTime);
        out.writeObject((Object)this.failureText);
    }

    public void readData(ObjectDataInput in) throws IOException {
        this.jobId = in.readLong();
        this.jobConfig = (JobConfig)in.readObject();
        this.coordinatorUUID = in.readUTF();
        this.creationTime = in.readLong();
        this.completionTime = in.readLong();
        this.failureText = (String)in.readObject();
    }
}

