/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.impl.pipeline;

import com.hazelcast.jet.Traverser;
import com.hazelcast.jet.Traversers;
import com.hazelcast.jet.aggregate.AggregateOperation1;
import com.hazelcast.jet.aggregate.AggregateOperation2;
import com.hazelcast.jet.aggregate.AggregateOperation3;
import com.hazelcast.jet.core.ProcessorMetaSupplier;
import com.hazelcast.jet.function.BiFunctionEx;
import com.hazelcast.jet.function.BiPredicateEx;
import com.hazelcast.jet.function.FunctionEx;
import com.hazelcast.jet.function.PredicateEx;
import com.hazelcast.jet.function.TriFunction;
import com.hazelcast.jet.impl.pipeline.BatchStageWithKeyImpl;
import com.hazelcast.jet.impl.pipeline.ComputeStageImplBase;
import com.hazelcast.jet.impl.pipeline.FunctionAdapter;
import com.hazelcast.jet.impl.pipeline.PipelineImpl;
import com.hazelcast.jet.impl.pipeline.transform.AbstractTransform;
import com.hazelcast.jet.impl.pipeline.transform.AggregateTransform;
import com.hazelcast.jet.impl.pipeline.transform.Transform;
import com.hazelcast.jet.impl.util.Util;
import com.hazelcast.jet.pipeline.BatchStage;
import com.hazelcast.jet.pipeline.BatchStageWithKey;
import com.hazelcast.jet.pipeline.ContextFactory;
import com.hazelcast.jet.pipeline.JoinClause;
import java.util.Arrays;
import java.util.Collections;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Nonnull;

public class BatchStageImpl<T>
extends ComputeStageImplBase<T>
implements BatchStage<T> {
    BatchStageImpl(@Nonnull Transform transform, @Nonnull PipelineImpl pipeline) {
        super(transform, DO_NOT_ADAPT, pipeline, true);
    }

    public BatchStageImpl(@Nonnull Transform transform, FunctionAdapter ignored, @Nonnull PipelineImpl pipeline) {
        this(transform, pipeline);
    }

    @Override
    @Nonnull
    public <K> BatchStageWithKey<T, K> groupingKey(@Nonnull FunctionEx<? super T, ? extends K> keyFn) {
        Util.checkSerializable(keyFn, "keyFn");
        return new BatchStageWithKeyImpl<T, K>(this, keyFn);
    }

    @Override
    @Nonnull
    public <R> BatchStage<R> map(@Nonnull FunctionEx<? super T, ? extends R> mapFn) {
        return (BatchStage)this.attachMap(mapFn);
    }

    @Override
    @Nonnull
    public BatchStage<T> filter(@Nonnull PredicateEx<T> filterFn) {
        return (BatchStage)this.attachFilter(filterFn);
    }

    @Override
    @Nonnull
    public <R> BatchStage<R> flatMap(@Nonnull FunctionEx<? super T, ? extends Traverser<? extends R>> flatMapFn) {
        return (BatchStage)this.attachFlatMap(flatMapFn);
    }

    @Override
    @Nonnull
    public <C, R> BatchStage<R> mapUsingContext(@Nonnull ContextFactory<C> contextFactory, @Nonnull BiFunctionEx<? super C, ? super T, ? extends R> mapFn) {
        return (BatchStage)this.attachMapUsingContext(contextFactory, mapFn);
    }

    @Override
    @Nonnull
    public <C, R> BatchStage<R> mapUsingContextAsync(@Nonnull ContextFactory<C> contextFactory, @Nonnull BiFunctionEx<? super C, ? super T, ? extends CompletableFuture<R>> mapAsyncFn) {
        return (BatchStage)this.attachFlatMapUsingContextAsync("map", contextFactory, (c, t) -> ((CompletableFuture)mapAsyncFn.apply((Object)c, (Object)t)).thenApply(Traversers::singleton));
    }

    @Override
    @Nonnull
    public <C> BatchStage<T> filterUsingContext(@Nonnull ContextFactory<C> contextFactory, @Nonnull BiPredicateEx<? super C, ? super T> filterFn) {
        return (BatchStage)this.attachFilterUsingContext(contextFactory, filterFn);
    }

    @Override
    @Nonnull
    public <C> BatchStage<T> filterUsingContextAsync(@Nonnull ContextFactory<C> contextFactory, @Nonnull BiFunctionEx<? super C, ? super T, ? extends CompletableFuture<Boolean>> filterAsyncFn) {
        return (BatchStage)this.attachFlatMapUsingContextAsync("filter", contextFactory, (c, t) -> ((CompletableFuture)filterAsyncFn.apply((Object)c, (Object)t)).thenApply(passed -> passed != false ? Traversers.singleton(t) : null));
    }

    @Override
    @Nonnull
    public <C, R> BatchStage<R> flatMapUsingContext(@Nonnull ContextFactory<C> contextFactory, @Nonnull BiFunctionEx<? super C, ? super T, ? extends Traverser<R>> flatMapFn) {
        return (BatchStage)this.attachFlatMapUsingContext(contextFactory, flatMapFn);
    }

    @Override
    @Nonnull
    public <C, R> BatchStage<R> flatMapUsingContextAsync(@Nonnull ContextFactory<C> contextFactory, @Nonnull BiFunctionEx<? super C, ? super T, ? extends CompletableFuture<Traverser<R>>> flatMapAsyncFn) {
        return (BatchStage)this.attachFlatMapUsingContextAsync("flatMap", contextFactory, flatMapAsyncFn);
    }

    @Override
    @Nonnull
    public <R> BatchStage<R> rollingAggregate(@Nonnull AggregateOperation1<? super T, ?, ? extends R> aggrOp) {
        return (BatchStage)this.attachGlobalRollingAggregate(aggrOp);
    }

    @Override
    @Nonnull
    public BatchStage<T> merge(@Nonnull BatchStage<? extends T> other) {
        return (BatchStage)this.attachMerge(other);
    }

    @Override
    @Nonnull
    public <K, T1_IN, T1, R> BatchStage<R> hashJoin(@Nonnull BatchStage<T1_IN> stage1, @Nonnull JoinClause<K, ? super T, ? super T1_IN, ? extends T1> joinClause1, @Nonnull BiFunctionEx<T, T1, R> mapToOutputFn) {
        return (BatchStage)this.attachHashJoin(stage1, joinClause1, mapToOutputFn);
    }

    @Override
    @Nonnull
    public <K1, K2, T1_IN, T2_IN, T1, T2, R> BatchStage<R> hashJoin2(@Nonnull BatchStage<T1_IN> stage1, @Nonnull JoinClause<K1, ? super T, ? super T1_IN, ? extends T1> joinClause1, @Nonnull BatchStage<T2_IN> stage2, @Nonnull JoinClause<K2, ? super T, ? super T2_IN, ? extends T2> joinClause2, @Nonnull TriFunction<T, T1, T2, R> mapToOutputFn) {
        return (BatchStage)this.attachHashJoin2(stage1, joinClause1, stage2, joinClause2, mapToOutputFn);
    }

    @Override
    @Nonnull
    public <R> BatchStage<R> aggregate(@Nonnull AggregateOperation1<? super T, ?, ? extends R> aggrOp) {
        return (BatchStage)this.attach(new AggregateTransform(Collections.singletonList(this.transform), aggrOp), this.fnAdapter);
    }

    @Override
    @Nonnull
    public <T1, R> BatchStage<R> aggregate2(@Nonnull BatchStage<T1> stage1, @Nonnull AggregateOperation2<? super T, ? super T1, ?, ? extends R> aggrOp) {
        return (BatchStage)this.attach(new AggregateTransform(Arrays.asList(this.transform, BatchStageImpl.transformOf(stage1)), aggrOp), DO_NOT_ADAPT);
    }

    @Override
    @Nonnull
    public <T1, T2, R> BatchStage<R> aggregate3(@Nonnull BatchStage<T1> stage1, @Nonnull BatchStage<T2> stage2, @Nonnull AggregateOperation3<? super T, ? super T1, ? super T2, ?, ? extends R> aggrOp) {
        return (BatchStage)this.attach(new AggregateTransform(Arrays.asList(this.transform, BatchStageImpl.transformOf(stage1), BatchStageImpl.transformOf(stage2)), aggrOp), DO_NOT_ADAPT);
    }

    @Override
    @Nonnull
    public BatchStage<T> peek(@Nonnull PredicateEx<? super T> shouldLogFn, @Nonnull FunctionEx<? super T, ? extends CharSequence> toStringFn) {
        return (BatchStage)this.attachPeek(shouldLogFn, toStringFn);
    }

    @Override
    @Nonnull
    public <R> BatchStage<R> customTransform(@Nonnull String stageName, @Nonnull ProcessorMetaSupplier procSupplier) {
        return (BatchStage)this.attachCustomTransform(stageName, procSupplier);
    }

    @Override
    @Nonnull
    <RET> RET attach(@Nonnull AbstractTransform transform, @Nonnull FunctionAdapter fnAdapter) {
        this.pipelineImpl.connect(transform.upstream(), (Transform)transform);
        return (RET)new BatchStageImpl<T>(transform, this.pipelineImpl);
    }

    @Override
    @Nonnull
    public BatchStage<T> setLocalParallelism(int localParallelism) {
        super.setLocalParallelism(localParallelism);
        return this;
    }

    @Override
    @Nonnull
    public BatchStage<T> setName(@Nonnull String name) {
        super.setName(name);
        return this;
    }
}

