/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.impl.operation;

import com.hazelcast.jet.impl.JetService;
import com.hazelcast.jet.impl.JobCoordinationService;
import com.hazelcast.jet.impl.execution.init.JetInitDataSerializerHook;
import com.hazelcast.jet.impl.util.ExceptionUtil;
import com.hazelcast.nio.serialization.IdentifiedDataSerializable;
import com.hazelcast.spi.ExceptionAction;
import com.hazelcast.spi.Operation;
import java.util.concurrent.CompletableFuture;
import java.util.function.BiConsumer;

public abstract class AsyncOperation
extends Operation
implements IdentifiedDataSerializable {
    public void beforeRun() {
        JetService service = (JetService)this.getService();
        service.getLiveOperationRegistry().register(this);
    }

    public final void run() {
        CompletableFuture<?> future;
        try {
            future = this.doRun();
        }
        catch (Exception e) {
            this.logError(e);
            this.doSendResponse(e);
            return;
        }
        future.whenComplete((BiConsumer)ExceptionUtil.withTryCatch(this.getLogger(), (r, f) -> this.doSendResponse(f != null ? ExceptionUtil.peel(f) : r)));
    }

    protected abstract CompletableFuture<?> doRun() throws Exception;

    public final boolean returnsResponse() {
        return false;
    }

    public final Object getResponse() {
        throw new UnsupportedOperationException();
    }

    private void doSendResponse(Object value) {
        try {
            JetService service = (JetService)this.getService();
            service.getLiveOperationRegistry().deregister(this);
        }
        finally {
            this.sendResponse(value);
        }
    }

    protected JetService getJetService() {
        assert (this.getServiceName().equals("hz:impl:jetService")) : "Service is not Jet Service";
        return (JetService)this.getService();
    }

    protected JobCoordinationService getJobCoordinationService() {
        return this.getJetService().getJobCoordinationService();
    }

    public ExceptionAction onInvocationException(Throwable throwable) {
        return ExceptionUtil.isRestartableException(throwable) ? ExceptionAction.THROW_EXCEPTION : super.onInvocationException(throwable);
    }

    public final int getFactoryId() {
        return JetInitDataSerializerHook.FACTORY_ID;
    }
}

