/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.impl.connector;

import com.hazelcast.jet.Traverser;
import com.hazelcast.jet.Traversers;
import com.hazelcast.jet.core.AbstractProcessor;
import com.hazelcast.jet.core.Processor;
import com.hazelcast.jet.core.ProcessorMetaSupplier;
import com.hazelcast.jet.function.BiFunctionEx;
import com.hazelcast.jet.function.FunctionEx;
import java.io.IOException;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.stream.Stream;
import javax.annotation.Nonnull;

public final class ReadFilesP<R, T>
extends AbstractProcessor {
    private final Path directory;
    private final String glob;
    private final boolean sharedFileSystem;
    private final FunctionEx<? super Path, ? extends Stream<R>> readFileFn;
    private final BiFunctionEx<? super String, ? super R, ? extends T> mapOutputFn;
    private int processorIndex;
    private int parallelism;
    private DirectoryStream<Path> directoryStream;
    private Traverser<? extends T> outputTraverser;
    private Stream<R> currentStream;

    private ReadFilesP(@Nonnull String directory, @Nonnull String glob, boolean sharedFileSystem, @Nonnull FunctionEx<? super Path, ? extends Stream<R>> readFileFn, @Nonnull BiFunctionEx<? super String, ? super R, ? extends T> mapOutputFn) {
        this.directory = Paths.get(directory, new String[0]);
        this.glob = glob;
        this.readFileFn = readFileFn;
        this.mapOutputFn = mapOutputFn;
        this.sharedFileSystem = sharedFileSystem;
    }

    @Override
    public boolean isCooperative() {
        return false;
    }

    @Override
    protected void init(@Nonnull Processor.Context context) throws Exception {
        this.processorIndex = this.sharedFileSystem ? context.globalProcessorIndex() : context.localProcessorIndex();
        this.parallelism = this.sharedFileSystem ? context.totalParallelism() : context.localParallelism();
        this.directoryStream = Files.newDirectoryStream(this.directory, this.glob);
        this.outputTraverser = Traversers.traverseIterator(this.directoryStream.iterator()).filter(this::shouldProcessEvent).flatMap(this::processFile);
    }

    @Override
    public boolean complete() {
        return this.emitFromTraverser(this.outputTraverser);
    }

    private boolean shouldProcessEvent(Path file) {
        if (Files.isDirectory(file, new LinkOption[0])) {
            return false;
        }
        int hashCode = file.hashCode();
        return (hashCode & Integer.MAX_VALUE) % this.parallelism == this.processorIndex;
    }

    private Traverser<? extends T> processFile(Path file) {
        if (this.getLogger().isFinestEnabled()) {
            this.getLogger().finest("Processing file " + file);
        }
        assert (this.currentStream == null) : "currentStream != null";
        this.currentStream = this.readFileFn.apply(file);
        String fileName = file.getFileName().toString();
        return Traversers.traverseStream(this.currentStream).map(line -> this.mapOutputFn.apply(fileName, line)).onFirstNull(() -> {
            this.currentStream.close();
            this.currentStream = null;
        });
    }

    @Override
    public void close() throws IOException {
        IOException ex = null;
        if (this.directoryStream != null) {
            try {
                this.directoryStream.close();
            }
            catch (IOException e) {
                ex = e;
            }
        }
        if (this.currentStream != null) {
            this.currentStream.close();
        }
        if (ex != null) {
            throw ex;
        }
    }

    public static <W, T> ProcessorMetaSupplier metaSupplier(@Nonnull String directory, @Nonnull String glob, boolean sharedFileSystem, @Nonnull FunctionEx<? super Path, ? extends Stream<W>> readFileFn, @Nonnull BiFunctionEx<? super String, ? super W, ? extends T> mapOutputFn) {
        return ProcessorMetaSupplier.of(() -> new ReadFilesP(directory, glob, sharedFileSystem, readFileFn, mapOutputFn), 2);
    }
}

