/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.impl;

import com.hazelcast.client.impl.ClientEngineImpl;
import com.hazelcast.config.Config;
import com.hazelcast.core.ExecutionCallback;
import com.hazelcast.instance.HazelcastInstanceImpl;
import com.hazelcast.instance.Node;
import com.hazelcast.internal.partition.InternalPartitionService;
import com.hazelcast.jet.JetInstance;
import com.hazelcast.jet.config.JetConfig;
import com.hazelcast.jet.config.JobConfig;
import com.hazelcast.jet.core.JobNotFoundException;
import com.hazelcast.jet.impl.JetInstanceImpl;
import com.hazelcast.jet.impl.JobCoordinationService;
import com.hazelcast.jet.impl.JobExecutionService;
import com.hazelcast.jet.impl.JobRecord;
import com.hazelcast.jet.impl.JobRepository;
import com.hazelcast.jet.impl.JobResult;
import com.hazelcast.jet.impl.LiveOperationRegistry;
import com.hazelcast.jet.impl.MigrationWatcher;
import com.hazelcast.jet.impl.Networking;
import com.hazelcast.jet.impl.execution.TaskletExecutionService;
import com.hazelcast.jet.impl.operation.NotifyMemberShutdownOperation;
import com.hazelcast.jet.impl.util.ExceptionUtil;
import com.hazelcast.jet.impl.util.JetProperties;
import com.hazelcast.jet.impl.util.Util;
import com.hazelcast.logging.ILogger;
import com.hazelcast.nio.Packet;
import com.hazelcast.spi.LiveOperations;
import com.hazelcast.spi.LiveOperationsTracker;
import com.hazelcast.spi.ManagedService;
import com.hazelcast.spi.MemberAttributeServiceEvent;
import com.hazelcast.spi.MembershipAwareService;
import com.hazelcast.spi.MembershipServiceEvent;
import com.hazelcast.spi.NodeEngine;
import com.hazelcast.spi.Operation;
import com.hazelcast.spi.impl.NodeEngineImpl;
import com.hazelcast.spi.properties.GroupProperty;
import com.hazelcast.spi.properties.HazelcastProperties;
import java.io.IOException;
import java.util.Properties;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Supplier;

public class JetService
implements ManagedService,
MembershipAwareService,
LiveOperationsTracker {
    public static final String SERVICE_NAME = "hz:impl:jetService";
    public static final int MAX_PARALLEL_ASYNC_OPS = 1000;
    private static final int NOTIFY_MEMBER_SHUTDOWN_DELAY = 5;
    private NodeEngineImpl nodeEngine;
    private final ILogger logger;
    private final LiveOperationRegistry liveOperationRegistry;
    private final AtomicReference<CompletableFuture> shutdownFuture = new AtomicReference();
    private final Thread shutdownHookThread;
    private MigrationWatcher sharedMigrationWatcher;
    private JetConfig config;
    private JetInstance jetInstance;
    private Networking networking;
    private TaskletExecutionService taskletExecutionService;
    private JobRepository jobRepository;
    private JobCoordinationService jobCoordinationService;
    private JobExecutionService jobExecutionService;
    private final AtomicInteger numConcurrentAsyncOps = new AtomicInteger();
    private final Supplier<int[]> sharedPartitionKeys = Util.memoizeConcurrent(this::computeSharedPartitionKeys);

    public JetService(Node node) {
        this.logger = node.getLogger(this.getClass());
        this.liveOperationRegistry = new LiveOperationRegistry();
        this.shutdownHookThread = this.shutdownHookThread(node);
    }

    public void init(NodeEngine engine, Properties hzProperties) {
        this.nodeEngine = (NodeEngineImpl)engine;
        this.config = JetService.findJetServiceConfig(engine.getConfig());
        this.sharedMigrationWatcher = new MigrationWatcher(engine.getHazelcastInstance());
        this.jetInstance = new JetInstanceImpl((HazelcastInstanceImpl)engine.getHazelcastInstance(), this.config);
        HazelcastProperties jetProperties = new HazelcastProperties(this.config.getProperties());
        this.taskletExecutionService = new TaskletExecutionService(this.nodeEngine, this.config.getInstanceConfig().getCooperativeThreadCount(), jetProperties.getNanos(JetProperties.JET_MINIMUM_IDLE_MICROSECONDS));
        this.jobRepository = new JobRepository(this.jetInstance);
        this.jobExecutionService = new JobExecutionService(this.nodeEngine, this.taskletExecutionService, this.jobRepository);
        this.jobCoordinationService = this.createJobCoordinationService();
        this.networking = new Networking(engine, this.jobExecutionService, this.config.getInstanceConfig().getFlowControlPeriodMs());
        ClientEngineImpl clientEngine = (ClientEngineImpl)engine.getService("hz:core:clientEngine");
        ExceptionUtil.registerJetExceptions(clientEngine.getClientExceptions());
        if (Boolean.parseBoolean(this.config.getHazelcastConfig().getProperties().getProperty(JetProperties.JET_SHUTDOWNHOOK_ENABLED.getName()))) {
            this.logger.finest("Adding Jet shutdown hook");
            Runtime.getRuntime().addShutdownHook(this.shutdownHookThread);
        }
        this.logger.info("Setting number of cooperative threads and default parallelism to " + this.config.getInstanceConfig().getCooperativeThreadCount());
    }

    static JetConfig findJetServiceConfig(Config hzConfig) {
        return (JetConfig)hzConfig.getServicesConfig().getServiceConfig(SERVICE_NAME).getConfigObject();
    }

    void shutDownJobs() {
        if (this.shutdownFuture.compareAndSet(null, new CompletableFuture())) {
            this.notifyMasterWeAreShuttingDown(this.shutdownFuture.get());
        }
        this.shutdownFuture.get().join();
        assert (this.jobExecutionService.numberOfExecutions() == 0) : "numberOfExecutions should be zero, but is " + this.jobExecutionService.numberOfExecutions();
    }

    private void notifyMasterWeAreShuttingDown(final CompletableFuture<Void> future) {
        NotifyMemberShutdownOperation op = new NotifyMemberShutdownOperation();
        this.nodeEngine.getOperationService().invokeOnTarget(SERVICE_NAME, (Operation)op, this.nodeEngine.getClusterService().getMasterAddress()).andThen((ExecutionCallback)new ExecutionCallback<Object>(){

            public void onResponse(Object response) {
                future.complete(null);
            }

            public void onFailure(Throwable t) {
                JetService.this.logger.warning("Failed to notify master member that this member is shutting down, will retry in 5 seconds", t);
                JetService.this.nodeEngine.getExecutionService().schedule(() -> JetService.this.notifyMasterWeAreShuttingDown(future), 5L, TimeUnit.SECONDS);
            }
        });
    }

    public void shutdown(boolean forceful) {
        if (!Thread.currentThread().equals(this.shutdownHookThread)) {
            Runtime.getRuntime().removeShutdownHook(this.shutdownHookThread);
        }
        this.jobExecutionService.shutdown();
        this.taskletExecutionService.shutdown();
        this.taskletExecutionService.awaitWorkerTermination();
        this.networking.shutdown();
    }

    public void reset() {
        this.jobExecutionService.reset();
        this.jobCoordinationService.reset();
    }

    JobCoordinationService createJobCoordinationService() {
        return new JobCoordinationService(this.nodeEngine, this, this.config, this.jobRepository);
    }

    public Operation createExportSnapshotOperation(long jobId, String name, boolean cancelJob) {
        throw new UnsupportedOperationException("You need Hazelcast Jet Enterprise to use this feature");
    }

    public JetInstance getJetInstance() {
        return this.jetInstance;
    }

    public LiveOperationRegistry getLiveOperationRegistry() {
        return this.liveOperationRegistry;
    }

    public JobRepository getJobRepository() {
        return this.jobRepository;
    }

    public NodeEngineImpl getNodeEngine() {
        return this.nodeEngine;
    }

    public JetConfig getConfig() {
        return this.config;
    }

    public JobCoordinationService getJobCoordinationService() {
        return this.jobCoordinationService;
    }

    public JobExecutionService getJobExecutionService() {
        return this.jobExecutionService;
    }

    public JobConfig getJobConfig(long jobId) {
        JobRecord jobRecord = this.jobRepository.getJobRecord(jobId);
        if (jobRecord != null) {
            return jobRecord.getConfig();
        }
        JobResult jobResult = this.jobRepository.getJobResult(jobId);
        if (jobResult != null) {
            return jobResult.getJobConfig();
        }
        throw new JobNotFoundException(jobId);
    }

    public ClassLoader getClassLoader(long jobId) {
        return this.getJobExecutionService().getClassLoader(this.getJobConfig(jobId), jobId);
    }

    void handlePacket(Packet packet) {
        try {
            this.networking.handle(packet);
        }
        catch (IOException e) {
            throw ExceptionUtil.sneakyThrow(e);
        }
    }

    public void memberRemoved(MembershipServiceEvent event) {
        this.jobExecutionService.onMemberRemoved(event.getMember().getAddress());
        this.jobCoordinationService.onMemberRemoved(event.getMember().getUuid());
    }

    public void memberAdded(MembershipServiceEvent event) {
        this.jobCoordinationService.onMemberAdded(event.getMember());
    }

    public void memberAttributeChanged(MemberAttributeServiceEvent event) {
    }

    public AtomicInteger numConcurrentAsyncOps() {
        return this.numConcurrentAsyncOps;
    }

    public void populate(LiveOperations liveOperations) {
        this.liveOperationRegistry.populate(liveOperations);
    }

    public int[] getSharedPartitionKeys() {
        return this.sharedPartitionKeys.get();
    }

    private int[] computeSharedPartitionKeys() {
        InternalPartitionService partitionService = this.nodeEngine.getPartitionService();
        int[] keys = new int[partitionService.getPartitionCount()];
        int remainingCount = partitionService.getPartitionCount();
        int i = 1;
        while (remainingCount > 0) {
            int partitionId = partitionService.getPartitionId((Object)i);
            if (keys[partitionId] == 0) {
                keys[partitionId] = i;
                --remainingCount;
            }
            ++i;
        }
        return keys;
    }

    public MigrationWatcher getSharedMigrationWatcher() {
        return this.sharedMigrationWatcher;
    }

    private Thread shutdownHookThread(Node node) {
        return new Thread(() -> {
            String policy = node.getProperties().getString(GroupProperty.SHUTDOWNHOOK_POLICY);
            if (policy.equals("TERMINATE")) {
                this.jetInstance.getHazelcastInstance().getLifecycleService().terminate();
            } else {
                this.jetInstance.shutdown();
            }
        }, "jet.ShutdownThread");
    }
}

