/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.function;

import com.hazelcast.jet.function.ComparatorsEx;
import com.hazelcast.jet.function.FunctionEx;
import com.hazelcast.jet.function.ToDoubleFunctionEx;
import com.hazelcast.jet.function.ToIntFunctionEx;
import com.hazelcast.jet.function.ToLongFunctionEx;
import com.hazelcast.jet.impl.util.ExceptionUtil;
import com.hazelcast.jet.impl.util.Util;
import com.hazelcast.util.Preconditions;
import java.io.Serializable;
import java.util.Comparator;
import java.util.function.Function;
import java.util.function.ToDoubleFunction;
import java.util.function.ToIntFunction;
import java.util.function.ToLongFunction;

@FunctionalInterface
public interface ComparatorEx<T>
extends Comparator<T>,
Serializable {
    public int compareEx(T var1, T var2) throws Exception;

    @Override
    default public int compare(T o1, T o2) {
        try {
            return this.compareEx(o1, o2);
        }
        catch (Exception e) {
            throw ExceptionUtil.sneakyThrow(e);
        }
    }

    public static <T extends Comparable<? super T>> ComparatorEx<T> naturalOrder() {
        return ComparatorsEx.NATURAL_ORDER;
    }

    public static <T extends Comparable<? super T>> ComparatorEx<T> reverseOrder() {
        return ComparatorsEx.REVERSE_ORDER;
    }

    public static <T> ComparatorEx<T> nullsFirst(Comparator<? super T> comparator) {
        Util.checkSerializable(comparator, "comparator");
        ComparatorsEx.NullComparator c = new ComparatorsEx.NullComparator(true);
        return comparator != null ? c.thenComparing((Comparator)comparator) : c;
    }

    public static <T> ComparatorEx<T> nullsFirst(ComparatorEx<? super T> comparator) {
        return ComparatorEx.nullsFirst(comparator);
    }

    public static <T> ComparatorEx<T> nullsLast(Comparator<? super T> comparator) {
        Util.checkSerializable(comparator, "comparator");
        ComparatorsEx.NullComparator c = new ComparatorsEx.NullComparator(false);
        return comparator != null ? c.thenComparing((Comparator)comparator) : c;
    }

    public static <T> ComparatorEx<T> nullsLast(ComparatorEx<? super T> comparator) {
        return ComparatorEx.nullsLast(comparator);
    }

    public static <T, U> ComparatorEx<T> comparing(Function<? super T, ? extends U> toKeyFn, Comparator<? super U> keyComparator) {
        Preconditions.checkNotNull(toKeyFn, (String)"toKeyFn");
        Preconditions.checkNotNull(keyComparator, (String)"keyComparator");
        Util.checkSerializable(toKeyFn, "toKeyFn");
        Util.checkSerializable(keyComparator, "keyComparator");
        return (c1, c2) -> keyComparator.compare((Object)toKeyFn.apply(c1), (Object)toKeyFn.apply(c2));
    }

    public static <T, U> ComparatorEx<T> comparing(FunctionEx<? super T, ? extends U> toKeyFn, ComparatorEx<? super U> keyComparator) {
        return ComparatorEx.comparing(toKeyFn, keyComparator);
    }

    public static <T, U extends Comparable<? super U>> ComparatorEx<T> comparing(Function<? super T, ? extends U> toKeyFn) {
        Preconditions.checkNotNull(toKeyFn, (String)"toKeyFn");
        Util.checkSerializable(toKeyFn, "toKeyFn");
        return (left, right) -> ((Comparable)toKeyFn.apply(left)).compareTo(toKeyFn.apply(right));
    }

    public static <T, U extends Comparable<? super U>> ComparatorEx<T> comparing(FunctionEx<? super T, ? extends U> toKeyFn) {
        return ComparatorEx.comparing(toKeyFn);
    }

    public static <T> ComparatorEx<T> comparingInt(ToIntFunction<? super T> toKeyFn) {
        Preconditions.checkNotNull(toKeyFn, (String)"toKeyFn");
        Util.checkSerializable(toKeyFn, "toKeyFn");
        return (c1, c2) -> Integer.compare(toKeyFn.applyAsInt(c1), toKeyFn.applyAsInt(c2));
    }

    public static <T> ComparatorEx<T> comparingInt(ToIntFunctionEx<? super T> toKeyFn) {
        return ComparatorEx.comparingInt(toKeyFn);
    }

    public static <T> ComparatorEx<T> comparingLong(ToLongFunction<? super T> toKeyFn) {
        Preconditions.checkNotNull(toKeyFn, (String)"toKeyFn");
        Util.checkSerializable(toKeyFn, "toKeyFn");
        return (c1, c2) -> Long.compare(toKeyFn.applyAsLong(c1), toKeyFn.applyAsLong(c2));
    }

    public static <T> ComparatorEx<T> comparingLong(ToLongFunctionEx<? super T> toKeyFn) {
        return ComparatorEx.comparingLong(toKeyFn);
    }

    public static <T> ComparatorEx<T> comparingDouble(ToDoubleFunction<? super T> toKeyFn) {
        Preconditions.checkNotNull(toKeyFn, (String)"toKeyFn");
        Util.checkSerializable(toKeyFn, "toKeyFn");
        return (c1, c2) -> Double.compare(toKeyFn.applyAsDouble(c1), toKeyFn.applyAsDouble(c2));
    }

    public static <T> ComparatorEx<T> comparingDouble(ToDoubleFunctionEx<? super T> toKeyFn) {
        return ComparatorEx.comparingDouble(toKeyFn);
    }

    @Override
    default public ComparatorEx<T> thenComparing(Comparator<? super T> other) {
        Preconditions.checkNotNull(other, (String)"other");
        Util.checkSerializable(other, "other");
        return (c1, c2) -> {
            int res = this.compare(c1, c2);
            return res != 0 ? res : other.compare(c1, c2);
        };
    }

    @Override
    default public ComparatorEx<T> thenComparing(ComparatorEx<? super T> other) {
        return this.thenComparing((Comparator)other);
    }

    @Override
    default public <U> ComparatorEx<T> thenComparing(Function<? super T, ? extends U> toKeyFn, Comparator<? super U> keyComparator) {
        Util.checkSerializable(toKeyFn, "toKeyFn");
        Util.checkSerializable(keyComparator, "keyComparator");
        return this.thenComparing(ComparatorEx.comparing(toKeyFn, keyComparator));
    }

    @Override
    default public <U> ComparatorEx<T> thenComparing(FunctionEx<? super T, ? extends U> toKeyFn, ComparatorEx<? super U> keyComparator) {
        return this.thenComparing((Function)toKeyFn, (Comparator)keyComparator);
    }

    @Override
    default public <U extends Comparable<? super U>> ComparatorEx<T> thenComparing(Function<? super T, ? extends U> toKeyFn) {
        Util.checkSerializable(toKeyFn, "toKeyFn");
        return this.thenComparing(ComparatorEx.comparing(toKeyFn));
    }

    @Override
    default public <U extends Comparable<? super U>> ComparatorEx<T> thenComparing(FunctionEx<? super T, ? extends U> toKeyFn) {
        return this.thenComparing((Function)toKeyFn);
    }

    @Override
    default public ComparatorEx<T> thenComparingInt(ToIntFunction<? super T> toKeyFn) {
        Util.checkSerializable(toKeyFn, "toKeyFn");
        return this.thenComparing(ComparatorEx.comparingInt(toKeyFn));
    }

    @Override
    default public ComparatorEx<T> thenComparingInt(ToIntFunctionEx<? super T> toKeyFn) {
        return this.thenComparingInt((ToIntFunction)toKeyFn);
    }

    @Override
    default public ComparatorEx<T> thenComparingLong(ToLongFunction<? super T> toKeyFn) {
        Util.checkSerializable(toKeyFn, "toKeyFn");
        return this.thenComparing(ComparatorEx.comparingLong(toKeyFn));
    }

    @Override
    default public ComparatorEx<T> thenComparingLong(ToLongFunctionEx<? super T> toKeyFn) {
        return this.thenComparingLong((ToLongFunction)toKeyFn);
    }

    @Override
    default public ComparatorEx<T> thenComparingDouble(ToDoubleFunction<? super T> toKeyFn) {
        Util.checkSerializable(toKeyFn, "toKeyFn");
        return this.thenComparing(ComparatorEx.comparingDouble(toKeyFn));
    }

    @Override
    default public ComparatorEx<T> thenComparingDouble(ToDoubleFunctionEx<? super T> toKeyFn) {
        return this.thenComparingDouble((ToDoubleFunction)toKeyFn);
    }

    @Override
    default public ComparatorEx<T> reversed() {
        return (o1, o2) -> this.compare(o2, o1);
    }
}

