/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.impl.pipeline.transform;

import com.hazelcast.jet.Traverser;
import com.hazelcast.jet.core.ProcessorMetaSupplier;
import com.hazelcast.jet.core.processor.Processors;
import com.hazelcast.jet.function.BiFunctionEx;
import com.hazelcast.jet.function.BiPredicateEx;
import com.hazelcast.jet.function.FunctionEx;
import com.hazelcast.jet.impl.pipeline.Planner;
import com.hazelcast.jet.impl.pipeline.transform.ProcessorTransform;
import com.hazelcast.jet.impl.pipeline.transform.Transform;
import com.hazelcast.jet.pipeline.ContextFactory;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Nonnull;

public final class PartitionedProcessorTransform<T, K>
extends ProcessorTransform {
    private final FunctionEx<? super T, ? extends K> partitionKeyFn;

    private PartitionedProcessorTransform(@Nonnull String name, @Nonnull Transform upstream, @Nonnull ProcessorMetaSupplier processorSupplier, @Nonnull FunctionEx<? super T, ? extends K> partitionKeyFn) {
        super(name, upstream, processorSupplier);
        this.partitionKeyFn = partitionKeyFn;
    }

    public static <T, K> PartitionedProcessorTransform<T, K> partitionedCustomProcessorTransform(@Nonnull String name, @Nonnull Transform upstream, @Nonnull ProcessorMetaSupplier processorSupplier, @Nonnull FunctionEx<? super T, ? extends K> partitionKeyFn) {
        return new PartitionedProcessorTransform<T, K>(name, upstream, processorSupplier, partitionKeyFn);
    }

    public static <C, T, K, R> PartitionedProcessorTransform<T, K> mapUsingContextPartitionedTransform(@Nonnull Transform upstream, @Nonnull ContextFactory<C> contextFactory, @Nonnull BiFunctionEx<? super C, ? super T, ? extends R> mapFn, @Nonnull FunctionEx<? super T, ? extends K> partitionKeyFn) {
        return new PartitionedProcessorTransform<T, K>("mapUsingPartitionedContext", upstream, ProcessorMetaSupplier.of(Processors.mapUsingContextP(contextFactory, mapFn)), partitionKeyFn);
    }

    public static <C, T, K> PartitionedProcessorTransform<T, K> filterUsingPartitionedContextTransform(@Nonnull Transform upstream, @Nonnull ContextFactory<C> contextFactory, @Nonnull BiPredicateEx<? super C, ? super T> filterFn, @Nonnull FunctionEx<? super T, ? extends K> partitionKeyFn) {
        return new PartitionedProcessorTransform<T, K>("filterUsingPartitionedContext", upstream, ProcessorMetaSupplier.of(Processors.filterUsingContextP(contextFactory, filterFn)), partitionKeyFn);
    }

    public static <C, T, K, R> PartitionedProcessorTransform<T, K> flatMapUsingPartitionedContextTransform(@Nonnull Transform upstream, @Nonnull ContextFactory<C> contextFactory, @Nonnull BiFunctionEx<? super C, ? super T, ? extends Traverser<? extends R>> flatMapFn, @Nonnull FunctionEx<? super T, ? extends K> partitionKeyFn) {
        return new PartitionedProcessorTransform<T, K>("flatMapUsingPartitionedContext", upstream, ProcessorMetaSupplier.of(Processors.flatMapUsingContextP(contextFactory, flatMapFn)), partitionKeyFn);
    }

    public static <C, T, K, R> PartitionedProcessorTransform<T, K> flatMapUsingPartitionedContextAsyncTransform(@Nonnull Transform upstream, @Nonnull String operationName, @Nonnull ContextFactory<C> contextFactory, @Nonnull BiFunctionEx<? super C, ? super T, CompletableFuture<Traverser<R>>> flatMapAsyncFn, @Nonnull FunctionEx<? super T, ? extends K> partitionKeyFn) {
        return new PartitionedProcessorTransform<T, K>(operationName + "UsingPartitionedContextAsync", upstream, ProcessorMetaSupplier.of(Processors.flatMapUsingContextAsyncP(contextFactory, partitionKeyFn, flatMapAsyncFn)), partitionKeyFn);
    }

    @Override
    public void addToDag(Planner p) {
        Planner.PlannerVertex pv = p.addVertex((Transform)this, this.name(), this.localParallelism(), this.processorSupplier);
        p.addEdges((Transform)this, pv.v, e -> e.partitioned(this.partitionKeyFn).distributed());
    }
}

