/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.impl.pipeline;

import com.hazelcast.jet.Traverser;
import com.hazelcast.jet.function.FunctionEx;
import com.hazelcast.jet.function.TriFunction;
import com.hazelcast.jet.function.TriPredicate;
import com.hazelcast.jet.impl.pipeline.ComputeStageImplBase;
import com.hazelcast.jet.impl.pipeline.transform.Transform;
import com.hazelcast.jet.impl.util.Util;
import com.hazelcast.jet.pipeline.ContextFactory;
import com.hazelcast.jet.pipeline.GeneralStageWithKey;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Nonnull;

class StageWithGroupingBase<T, K> {
    final ComputeStageImplBase<T> computeStage;
    private final FunctionEx<? super T, ? extends K> keyFn;

    StageWithGroupingBase(@Nonnull ComputeStageImplBase<T> computeStage, @Nonnull FunctionEx<? super T, ? extends K> keyFn) {
        Util.checkSerializable(keyFn, "keyFn");
        this.computeStage = computeStage;
        this.keyFn = keyFn;
    }

    @Nonnull
    public FunctionEx<? super T, ? extends K> keyFn() {
        return this.keyFn;
    }

    @Nonnull
    <C, R, RET> RET attachMapUsingContext(@Nonnull ContextFactory<C> contextFactory, @Nonnull TriFunction<? super C, ? super K, ? super T, ? extends R> mapFn) {
        FunctionEx keyFn = this.keyFn();
        return this.computeStage.attachMapUsingPartitionedContext(contextFactory, keyFn, (c, t) -> {
            Object k = keyFn.apply(t);
            return mapFn.apply((Object)c, (Object)k, (Object)t);
        });
    }

    @Nonnull
    <C, RET> RET attachFilterUsingContext(@Nonnull ContextFactory<C> contextFactory, @Nonnull TriPredicate<? super C, ? super K, ? super T> filterFn) {
        FunctionEx keyFn = this.keyFn();
        return this.computeStage.attachFilterUsingPartitionedContext(contextFactory, keyFn, (c, t) -> {
            Object k = keyFn.apply(t);
            return filterFn.test((Object)c, (Object)k, (Object)t);
        });
    }

    @Nonnull
    public <C, R, RET> RET attachFlatMapUsingContext(@Nonnull ContextFactory<C> contextFactory, @Nonnull TriFunction<? super C, ? super K, ? super T, ? extends Traverser<? extends R>> flatMapFn) {
        FunctionEx keyFn = this.keyFn();
        return this.computeStage.attachFlatMapUsingPartitionedContext(contextFactory, keyFn, (c, t) -> {
            Object k = keyFn.apply(t);
            return (Traverser)flatMapFn.apply((Object)c, (Object)k, (Object)t);
        });
    }

    @Nonnull
    <C, R, RET> RET attachTransformUsingContextAsync(@Nonnull String operationName, @Nonnull ContextFactory<C> contextFactory, @Nonnull TriFunction<? super C, ? super K, ? super T, CompletableFuture<Traverser<R>>> flatMapAsyncFn) {
        FunctionEx keyFn = this.keyFn();
        return this.computeStage.attachTransformUsingPartitionedContextAsync(operationName, contextFactory, keyFn, (c, t) -> {
            Object k = keyFn.apply(t);
            return (CompletableFuture)flatMapAsyncFn.apply((Object)c, (Object)k, (Object)t);
        });
    }

    static Transform transformOf(GeneralStageWithKey stage) {
        return ((StageWithGroupingBase)((Object)stage)).computeStage.transform;
    }
}

