/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.impl.connector;

import com.hazelcast.jet.JetException;
import com.hazelcast.jet.core.Inbox;
import com.hazelcast.jet.core.Outbox;
import com.hazelcast.jet.core.Processor;
import com.hazelcast.jet.core.Watermark;
import com.hazelcast.jet.function.BiConsumerEx;
import com.hazelcast.jet.function.ConsumerEx;
import com.hazelcast.jet.function.FunctionEx;
import com.hazelcast.jet.function.SupplierEx;
import java.util.function.Consumer;
import javax.annotation.Nonnull;

public final class WriteBufferedP<B, T>
implements Processor {
    private final FunctionEx<? super Processor.Context, B> createFn;
    private final ConsumerEx<? super B> flushFn;
    private final ConsumerEx<? super B> destroyFn;
    private B buffer;
    private final Consumer<Object> inboxConsumer;

    WriteBufferedP(@Nonnull FunctionEx<? super Processor.Context, B> createFn, @Nonnull BiConsumerEx<? super B, ? super T> onReceiveFn, @Nonnull ConsumerEx<? super B> flushFn, @Nonnull ConsumerEx<? super B> destroyFn) {
        this.createFn = createFn;
        this.flushFn = flushFn;
        this.destroyFn = destroyFn;
        this.inboxConsumer = item -> onReceiveFn.accept((B)this.buffer, (T)item);
    }

    @Override
    public void init(@Nonnull Outbox outbox, @Nonnull Processor.Context context) {
        this.buffer = this.createFn.apply(context);
        if (this.buffer == null) {
            throw new JetException("Null buffer created");
        }
    }

    @Override
    public void process(int ordinal, @Nonnull Inbox inbox) {
        inbox.drain(this.inboxConsumer);
        this.flushFn.accept(this.buffer);
    }

    @Override
    public boolean tryProcessWatermark(@Nonnull Watermark watermark) {
        return true;
    }

    @Override
    public boolean complete() {
        return true;
    }

    @Override
    public void close() {
        if (this.buffer != null) {
            this.destroyFn.accept(this.buffer);
        }
    }

    @Override
    public boolean isCooperative() {
        return false;
    }

    @Nonnull
    public static <B, T> SupplierEx<Processor> supplier(@Nonnull FunctionEx<? super Processor.Context, ? extends B> createFn, @Nonnull BiConsumerEx<? super B, ? super T> onReceiveFn, @Nonnull ConsumerEx<? super B> flushFn, @Nonnull ConsumerEx<? super B> destroyFn) {
        return () -> new WriteBufferedP(createFn, onReceiveFn, flushFn, destroyFn);
    }
}

