/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.impl;

import com.hazelcast.aggregation.Aggregators;
import com.hazelcast.core.IMap;
import com.hazelcast.jet.JetException;
import com.hazelcast.jet.impl.SnapshotValidationRecord;
import com.hazelcast.jet.impl.util.AsyncSnapshotWriterImpl;
import com.hazelcast.query.Predicate;
import java.io.Serializable;

final class SnapshotValidator {
    private SnapshotValidator() {
    }

    static long validateSnapshot(long snapshotId, String jobIdString, IMap<Object, Object> map) {
        SnapshotValidationRecord validationRecord = (SnapshotValidationRecord)map.get((Object)SnapshotValidationRecord.KEY);
        if (validationRecord == null) {
            throw new JetException("State for " + jobIdString + " was supposed to be restored from '" + map.getName() + "', but that map doesn't contain the validation record: not an IMap with Jet snapshot or corrupted");
        }
        if (validationRecord.numChunks() != (long)(map.size() - 1)) {
            Long filteredCount = (Long)map.aggregate(Aggregators.count(), (Predicate & Serializable)e -> e.getKey() instanceof AsyncSnapshotWriterImpl.SnapshotDataKey && ((AsyncSnapshotWriterImpl.SnapshotDataKey)e.getKey()).snapshotId() == snapshotId);
            if (validationRecord.numChunks() != filteredCount.longValue()) {
                throw new JetException("State for " + jobIdString + " in '" + map.getName() + "' corrupted: it should have " + validationRecord.numChunks() + " entries, but has " + (map.size() - 1));
            }
        }
        if (snapshotId != -1L && snapshotId != validationRecord.snapshotId()) {
            throw new JetException(jobIdString + ": '" + map.getName() + "' was supposed to contain snapshotId=" + snapshotId + ", but it contains snapshotId=" + validationRecord.snapshotId());
        }
        return validationRecord.snapshotId();
    }
}

