/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.impl;

import com.hazelcast.core.ExecutionCallback;
import com.hazelcast.internal.cluster.MemberInfo;
import com.hazelcast.jet.config.JobConfig;
import com.hazelcast.jet.core.JobStatus;
import com.hazelcast.jet.impl.JetService;
import com.hazelcast.jet.impl.JobCoordinationService;
import com.hazelcast.jet.impl.JobExecutionRecord;
import com.hazelcast.jet.impl.JobRecord;
import com.hazelcast.jet.impl.JobRepository;
import com.hazelcast.jet.impl.MasterJobContext;
import com.hazelcast.jet.impl.MasterSnapshotContext;
import com.hazelcast.jet.impl.execution.init.ExecutionPlan;
import com.hazelcast.jet.impl.util.ExceptionUtil;
import com.hazelcast.jet.impl.util.Util;
import com.hazelcast.logging.ILogger;
import com.hazelcast.spi.InternalCompletableFuture;
import com.hazelcast.spi.NodeEngine;
import com.hazelcast.spi.Operation;
import com.hazelcast.spi.impl.NodeEngineImpl;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Consumer;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class MasterContext {
    private static final Object NULL_OBJECT = new Object(){

        public String toString() {
            return "NULL_OBJECT";
        }
    };
    private final ReentrantLock lock = new ReentrantLock();
    private final NodeEngineImpl nodeEngine;
    private final JobCoordinationService coordinationService;
    private final ILogger logger;
    private final long jobId;
    private final String jobName;
    private final JobRepository jobRepository;
    private final JobRecord jobRecord;
    private final JobExecutionRecord jobExecutionRecord;
    private volatile JobStatus jobStatus = JobStatus.NOT_RUNNING;
    private volatile long executionId;
    private volatile Map<MemberInfo, ExecutionPlan> executionPlanMap;
    private final MasterJobContext jobContext;
    private final MasterSnapshotContext snapshotContext;

    MasterContext(NodeEngineImpl nodeEngine, JobCoordinationService coordinationService, @Nonnull JobRecord jobRecord, @Nonnull JobExecutionRecord jobExecutionRecord) {
        this.nodeEngine = nodeEngine;
        this.coordinationService = coordinationService;
        this.jobRepository = coordinationService.jobRepository();
        this.logger = nodeEngine.getLogger(this.getClass());
        this.jobRecord = jobRecord;
        this.jobExecutionRecord = jobExecutionRecord;
        this.jobId = jobRecord.getJobId();
        this.jobName = jobRecord.getJobNameOrId();
        if (jobExecutionRecord.isSuspended()) {
            this.jobStatus = JobStatus.SUSPENDED;
        }
        this.jobContext = new MasterJobContext(this, nodeEngine.getLogger(MasterJobContext.class));
        this.snapshotContext = this.createMasterSnapshotContext(nodeEngine);
    }

    MasterSnapshotContext createMasterSnapshotContext(NodeEngineImpl nodeEngine) {
        return new MasterSnapshotContext(this, nodeEngine.getLogger(MasterSnapshotContext.class));
    }

    void lock() {
        this.assertLockNotHeld();
        this.lock.lock();
    }

    void unlock() {
        this.lock.unlock();
    }

    void assertLockHeld() {
        assert (this.lock.isHeldByCurrentThread()) : "the lock should be held at this place";
    }

    private void assertLockNotHeld() {
        assert (!this.lock.isHeldByCurrentThread()) : "the lock should not be held at this place";
    }

    public long jobId() {
        return this.jobId;
    }

    public long executionId() {
        return this.executionId;
    }

    public void setExecutionId(long newExecutionId) {
        this.executionId = newExecutionId;
    }

    public JobStatus jobStatus() {
        return this.jobStatus;
    }

    void setJobStatus(JobStatus jobStatus) {
        this.jobStatus = jobStatus;
    }

    public JobConfig jobConfig() {
        return this.jobRecord.getConfig();
    }

    JobRecord jobRecord() {
        return this.jobRecord;
    }

    public MasterJobContext jobContext() {
        return this.jobContext;
    }

    public MasterSnapshotContext snapshotContext() {
        return this.snapshotContext;
    }

    public JobExecutionRecord jobExecutionRecord() {
        return this.jobExecutionRecord;
    }

    String jobName() {
        return this.jobName;
    }

    String jobIdString() {
        return Util.jobNameAndExecutionId(this.jobName, this.executionId);
    }

    public JetService getJetService() {
        return this.coordinationService.getJetService();
    }

    public NodeEngine nodeEngine() {
        return this.nodeEngine;
    }

    public JobRepository jobRepository() {
        return this.jobRepository;
    }

    JobCoordinationService coordinationService() {
        return this.coordinationService;
    }

    Map<MemberInfo, ExecutionPlan> executionPlanMap() {
        return this.executionPlanMap;
    }

    void setExecutionPlanMap(Map<MemberInfo, ExecutionPlan> executionPlans) {
        this.executionPlanMap = executionPlans;
    }

    void updateQuorumSize(int newQuorumSize) {
        if (this.jobExecutionRecord.getQuorumSize() < newQuorumSize) {
            this.jobExecutionRecord.setLargerQuorumSize(newQuorumSize);
            this.writeJobExecutionRecord(false);
            this.logger.info("Current quorum size: " + this.jobExecutionRecord.getQuorumSize() + " of job " + com.hazelcast.jet.Util.idToString(this.jobRecord.getJobId()) + " is updated to: " + newQuorumSize);
        }
    }

    void writeJobExecutionRecord(boolean canCreate) {
        try {
            this.coordinationService.jobRepository().writeJobExecutionRecord(this.jobRecord.getJobId(), this.jobExecutionRecord, canCreate);
        }
        catch (RuntimeException e) {
            this.logger.warning("Failed to update JobExecutionRecord", (Throwable)e);
        }
    }

    void invokeOnParticipants(Function<ExecutionPlan, Operation> operationCtor, @Nullable Consumer<Map<MemberInfo, Object>> completionCallback, @Nullable ExecutionCallback<Object> callback) {
        ConcurrentHashMap responses = new ConcurrentHashMap();
        AtomicInteger remainingCount = new AtomicInteger(this.executionPlanMap.size());
        for (Map.Entry<MemberInfo, ExecutionPlan> entry : this.executionPlanMap.entrySet()) {
            MemberInfo member = entry.getKey();
            Operation op = operationCtor.apply(entry.getValue());
            InternalCompletableFuture future = this.nodeEngine.getOperationService().createInvocationBuilder("hz:impl:jetService", op, member.getAddress()).invoke();
            if (completionCallback != null) {
                future.andThen(Util.callbackOf((r, throwable) -> {
                    Object response = r != null ? r : (throwable != null ? ExceptionUtil.peel(throwable) : NULL_OBJECT);
                    Object oldResponse = responses.put(member, response);
                    assert (oldResponse == null) : "Duplicate response for " + member + ". Old=" + oldResponse + ", new=" + response;
                    if (remainingCount.decrementAndGet() == 0) {
                        completionCallback.accept(responses);
                    }
                }));
            }
            if (callback == null) continue;
            future.andThen(callback);
        }
    }
}

