/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.core;

import com.hazelcast.jet.JetInstance;
import com.hazelcast.jet.config.JobConfig;
import com.hazelcast.jet.config.ProcessingGuarantee;
import com.hazelcast.jet.core.AbstractProcessor;
import com.hazelcast.jet.core.Processor;
import com.hazelcast.jet.core.ProcessorSupplier;
import com.hazelcast.jet.core.Vertex;
import com.hazelcast.jet.function.FunctionEx;
import com.hazelcast.jet.function.SupplierEx;
import com.hazelcast.logging.ILogger;
import com.hazelcast.nio.Address;
import com.hazelcast.partition.strategy.StringPartitioningStrategy;
import com.hazelcast.util.UuidUtil;
import java.io.Serializable;
import java.util.Collections;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@FunctionalInterface
public interface ProcessorMetaSupplier
extends Serializable {
    default public int preferredLocalParallelism() {
        return -1;
    }

    default public void init(@Nonnull Context context) throws Exception {
    }

    @Nonnull
    public Function<? super Address, ? extends ProcessorSupplier> get(@Nonnull List<Address> var1);

    default public void close(@Nullable Throwable error) throws Exception {
    }

    @Nonnull
    public static ProcessorMetaSupplier of(@Nonnull ProcessorSupplier procSupplier, int preferredLocalParallelism) {
        return ProcessorMetaSupplier.of((? super Address x) -> procSupplier, preferredLocalParallelism);
    }

    @Nonnull
    public static ProcessorMetaSupplier of(@Nonnull ProcessorSupplier procSupplier) {
        return ProcessorMetaSupplier.of(procSupplier, -1);
    }

    @Nonnull
    public static ProcessorMetaSupplier of(@Nonnull SupplierEx<? extends Processor> procSupplier, int preferredLocalParallelism) {
        return ProcessorMetaSupplier.of(ProcessorSupplier.of(procSupplier), preferredLocalParallelism);
    }

    @Nonnull
    public static ProcessorMetaSupplier of(@Nonnull SupplierEx<? extends Processor> procSupplier) {
        return ProcessorMetaSupplier.of(procSupplier, -1);
    }

    @Nonnull
    public static ProcessorMetaSupplier of(final @Nonnull FunctionEx<? super Address, ? extends ProcessorSupplier> addressToSupplier, final int preferredLocalParallelism) {
        Vertex.checkLocalParallelism(preferredLocalParallelism);
        return new ProcessorMetaSupplier(){

            @Override
            public int preferredLocalParallelism() {
                return preferredLocalParallelism;
            }

            @Override
            @Nonnull
            public Function<? super Address, ? extends ProcessorSupplier> get(@Nonnull List<Address> addresses) {
                return addressToSupplier;
            }
        };
    }

    @Nonnull
    public static ProcessorMetaSupplier of(@Nonnull FunctionEx<? super Address, ? extends ProcessorSupplier> addressToSupplier) {
        return ProcessorMetaSupplier.of(addressToSupplier, -1);
    }

    @Nonnull
    public static ProcessorMetaSupplier preferLocalParallelismOne(@Nonnull ProcessorSupplier supplier) {
        return ProcessorMetaSupplier.of(supplier, 1);
    }

    @Nonnull
    public static ProcessorMetaSupplier preferLocalParallelismOne(@Nonnull SupplierEx<? extends Processor> procSupplier) {
        return ProcessorMetaSupplier.of(ProcessorSupplier.of(procSupplier), 1);
    }

    @Nonnull
    public static ProcessorMetaSupplier forceTotalParallelismOne(@Nonnull ProcessorSupplier supplier) {
        return ProcessorMetaSupplier.forceTotalParallelismOne(supplier, UuidUtil.newUnsecureUuidString());
    }

    @Nonnull
    public static ProcessorMetaSupplier forceTotalParallelismOne(final @Nonnull ProcessorSupplier supplier, final @Nonnull String partitionKey) {
        return new ProcessorMetaSupplier(){
            private transient Address ownerAddress;

            @Override
            public void init(@Nonnull Context context) {
                if (context.localParallelism() != 1) {
                    throw new IllegalArgumentException("Local parallelism of " + context.localParallelism() + " was requested for a vertex that supports only total parallelism of 1. Local parallelism should be 1.");
                }
                String key = StringPartitioningStrategy.getPartitionKey((String)partitionKey);
                this.ownerAddress = context.jetInstance().getHazelcastInstance().getPartitionService().getPartition((Object)key).getOwner().getAddress();
            }

            @Nonnull
            public Function<Address, ProcessorSupplier> get(@Nonnull List<Address> addresses) {
                return addr -> addr.equals((Object)this.ownerAddress) ? supplier : count -> Collections.singletonList(new AbstractProcessor(){

                    @Override
                    protected boolean tryProcess(int ordinal, @Nonnull Object item) {
                        throw new IllegalStateException("This vertex has a total parallelism of one and as such only expects input on one node. Edge configuration must be adjusted to make sure that only the expected node receives any input. Unexpected input received from ordinal " + ordinal + ": " + item);
                    }
                });
            }

            @Override
            public int preferredLocalParallelism() {
                return 1;
            }
        };
    }

    public static interface Context {
        @Nonnull
        public JetInstance jetInstance();

        public long jobId();

        public long executionId();

        @Nonnull
        public JobConfig jobConfig();

        public int totalParallelism();

        public int localParallelism();

        public int memberCount();

        @Nonnull
        public String vertexName();

        @Nonnull
        public ILogger logger();

        default public boolean snapshottingEnabled() {
            return this.processingGuarantee() != ProcessingGuarantee.NONE;
        }

        public ProcessingGuarantee processingGuarantee();
    }
}

