/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.pipeline;

import com.hazelcast.jet.aggregate.AggregateOperation1;
import com.hazelcast.jet.aggregate.AggregateOperation2;
import com.hazelcast.jet.aggregate.AggregateOperation3;
import com.hazelcast.jet.aggregate.AggregateOperations;
import com.hazelcast.jet.datamodel.TimestampedItem;
import com.hazelcast.jet.datamodel.Tuple2;
import com.hazelcast.jet.datamodel.Tuple3;
import com.hazelcast.jet.function.DistributedFunction;
import com.hazelcast.jet.function.DistributedFunctions;
import com.hazelcast.jet.function.WindowResult2Function;
import com.hazelcast.jet.function.WindowResult3Function;
import com.hazelcast.jet.function.WindowResultFunction;
import com.hazelcast.jet.pipeline.StageWithKeyAndWindow;
import com.hazelcast.jet.pipeline.StreamStage;
import com.hazelcast.jet.pipeline.WindowAggregateBuilder;
import com.hazelcast.jet.pipeline.WindowAggregateBuilder1;
import com.hazelcast.jet.pipeline.WindowDefinition;
import javax.annotation.Nonnull;

public interface StageWithWindow<T> {
    @Nonnull
    public StreamStage<T> streamStage();

    @Nonnull
    public WindowDefinition windowDefinition();

    @Nonnull
    public <K> StageWithKeyAndWindow<T, K> groupingKey(@Nonnull DistributedFunction<? super T, ? extends K> var1);

    @Nonnull
    default public <R> StreamStage<R> distinct(@Nonnull WindowResultFunction<? super T, ? extends R> mapToOutputFn) {
        return this.groupingKey(DistributedFunctions.wholeItem()).distinct(mapToOutputFn);
    }

    @Nonnull
    default public StreamStage<TimestampedItem<T>> distinct() {
        return this.groupingKey(DistributedFunctions.wholeItem()).distinct();
    }

    @Nonnull
    public <R, OUT> StreamStage<OUT> aggregate(@Nonnull AggregateOperation1<? super T, ?, ? extends R> var1, @Nonnull WindowResultFunction<? super R, ? extends OUT> var2);

    @Nonnull
    default public <R> StreamStage<TimestampedItem<R>> aggregate(@Nonnull AggregateOperation1<? super T, ?, R> aggrOp) {
        return this.aggregate(aggrOp, TimestampedItem::fromWindowResult);
    }

    @Nonnull
    public <T1, R, OUT> StreamStage<OUT> aggregate2(@Nonnull StreamStage<T1> var1, @Nonnull AggregateOperation2<? super T, ? super T1, ?, R> var2, @Nonnull WindowResultFunction<? super R, ? extends OUT> var3);

    @Nonnull
    default public <T1, R> StreamStage<TimestampedItem<R>> aggregate2(@Nonnull StreamStage<T1> stage1, @Nonnull AggregateOperation2<? super T, ? super T1, ?, R> aggrOp) {
        return this.aggregate2(stage1, aggrOp, TimestampedItem::fromWindowResult);
    }

    @Nonnull
    default public <T1, R0, R1, OUT> StreamStage<OUT> aggregate2(@Nonnull AggregateOperation1<? super T, ?, ? extends R0> aggrOp0, @Nonnull StreamStage<T1> stage1, @Nonnull AggregateOperation1<? super T1, ?, ? extends R1> aggrOp1, @Nonnull WindowResult2Function<? super R0, ? super R1, ? extends OUT> mapToOutputFn) {
        return this.aggregate2(stage1, AggregateOperations.aggregateOperation2(aggrOp0, aggrOp1, Tuple2::tuple2), (long start, long end, ? super R r) -> mapToOutputFn.apply(start, end, (Object)r.f0(), (Object)r.f1()));
    }

    @Nonnull
    default public <T1, R0, R1> StreamStage<TimestampedItem<Tuple2<R0, R1>>> aggregate2(@Nonnull AggregateOperation1<? super T, ?, ? extends R0> aggrOp0, @Nonnull StreamStage<T1> stage1, @Nonnull AggregateOperation1<? super T1, ?, ? extends R1> aggrOp1) {
        AggregateOperation2<? super T, ? super T1, Tuple2<?, ?>, Tuple2> aggrOp = AggregateOperations.aggregateOperation2(aggrOp0, aggrOp1, Tuple2::tuple2);
        return this.aggregate2(stage1, aggrOp, (long start, long end, ? super R t2) -> new TimestampedItem<Tuple2>(end, (Tuple2)t2));
    }

    @Nonnull
    public <T1, T2, R, OUT> StreamStage<OUT> aggregate3(@Nonnull StreamStage<T1> var1, @Nonnull StreamStage<T2> var2, @Nonnull AggregateOperation3<? super T, ? super T1, ? super T2, ?, R> var3, @Nonnull WindowResultFunction<? super R, ? extends OUT> var4);

    @Nonnull
    default public <T1, T2, R> StreamStage<TimestampedItem<R>> aggregate3(@Nonnull StreamStage<T1> stage1, @Nonnull StreamStage<T2> stage2, @Nonnull AggregateOperation3<? super T, ? super T1, ? super T2, ?, R> aggrOp) {
        return this.aggregate3(stage1, stage2, aggrOp, TimestampedItem::fromWindowResult);
    }

    @Nonnull
    default public <T1, T2, R0, R1, R2, OUT> StreamStage<OUT> aggregate3(@Nonnull AggregateOperation1<? super T, ?, ? extends R0> aggrOp0, @Nonnull StreamStage<T1> stage1, @Nonnull AggregateOperation1<? super T1, ?, ? extends R1> aggrOp1, @Nonnull StreamStage<T2> stage2, @Nonnull AggregateOperation1<? super T2, ?, ? extends R2> aggrOp2, @Nonnull WindowResult3Function<? super R0, ? super R1, ? super R2, ? extends OUT> mapToOutputFn) {
        return this.aggregate3(stage1, stage2, AggregateOperations.aggregateOperation3(aggrOp0, aggrOp1, aggrOp2, Tuple3::tuple3), (start, end, t3) -> mapToOutputFn.apply(start, end, (Object)t3.f0(), (Object)t3.f1(), (Object)t3.f2()));
    }

    @Nonnull
    default public <T1, T2, R0, R1, R2> StreamStage<TimestampedItem<Tuple3<R0, R1, R2>>> aggregate3(@Nonnull AggregateOperation1<? super T, ?, ? extends R0> aggrOp0, @Nonnull StreamStage<T1> stage1, @Nonnull AggregateOperation1<? super T1, ?, ? extends R1> aggrOp1, @Nonnull StreamStage<T2> stage2, @Nonnull AggregateOperation1<? super T2, ?, ? extends R2> aggrOp2) {
        AggregateOperation3<? super T, ? super T1, ? super T2, Tuple3<?, ?, ?>, Tuple3> aggrOp = AggregateOperations.aggregateOperation3(aggrOp0, aggrOp1, aggrOp2, Tuple3::tuple3);
        return this.aggregate3(stage1, stage2, aggrOp, (start, end, t3) -> new TimestampedItem<Tuple3>(end, (Tuple3)t3));
    }

    @Nonnull
    default public <R0> WindowAggregateBuilder<R0> aggregateBuilder(AggregateOperation1<? super T, ?, ? extends R0> aggrOp) {
        return new WindowAggregateBuilder<R0>(this.streamStage(), aggrOp, this.windowDefinition());
    }

    @Nonnull
    default public WindowAggregateBuilder1<T> aggregateBuilder() {
        return new WindowAggregateBuilder1<T>(this.streamStage(), this.windowDefinition());
    }
}

