/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.pipeline;

import com.hazelcast.jet.function.DistributedBiConsumer;
import com.hazelcast.jet.function.DistributedBiFunction;
import com.hazelcast.jet.function.DistributedConsumer;
import com.hazelcast.jet.function.DistributedFunction;
import com.hazelcast.jet.function.DistributedSupplier;
import com.hazelcast.jet.impl.connector.WriteJmsP;
import com.hazelcast.jet.impl.pipeline.SinkImpl;
import com.hazelcast.jet.impl.util.Util;
import com.hazelcast.jet.pipeline.Sink;
import com.hazelcast.util.Preconditions;
import javax.annotation.Nonnull;
import javax.jms.Connection;
import javax.jms.ConnectionFactory;
import javax.jms.Message;
import javax.jms.MessageProducer;
import javax.jms.Session;

public final class JmsSinkBuilder<T> {
    private final DistributedSupplier<ConnectionFactory> factorySupplier;
    private final boolean isTopic;
    private DistributedFunction<ConnectionFactory, Connection> connectionFn;
    private DistributedFunction<Connection, Session> sessionFn;
    private DistributedBiFunction<Session, T, Message> messageFn;
    private DistributedBiConsumer<MessageProducer, Message> sendFn;
    private DistributedConsumer<Session> flushFn;
    private String username;
    private String password;
    private boolean transacted;
    private int acknowledgeMode = 1;
    private String destinationName;

    JmsSinkBuilder(@Nonnull DistributedSupplier<ConnectionFactory> factorySupplier, boolean isTopic) {
        Util.checkSerializable(factorySupplier, "factorySupplier");
        this.factorySupplier = factorySupplier;
        this.isTopic = isTopic;
    }

    public JmsSinkBuilder<T> connectionParams(String username, String password) {
        this.username = username;
        this.password = password;
        return this;
    }

    public JmsSinkBuilder<T> connectionFn(@Nonnull DistributedFunction<ConnectionFactory, Connection> connectionFn) {
        Util.checkSerializable(connectionFn, "connectionFn");
        this.connectionFn = connectionFn;
        return this;
    }

    public JmsSinkBuilder<T> sessionParams(boolean transacted, int acknowledgeMode) {
        this.transacted = transacted;
        this.acknowledgeMode = acknowledgeMode;
        return this;
    }

    public JmsSinkBuilder<T> sessionFn(@Nonnull DistributedFunction<Connection, Session> sessionFn) {
        Util.checkSerializable(sessionFn, "sessionFn");
        this.sessionFn = sessionFn;
        return this;
    }

    public JmsSinkBuilder<T> destinationName(@Nonnull String destinationName) {
        this.destinationName = destinationName;
        return this;
    }

    public JmsSinkBuilder<T> messageFn(DistributedBiFunction<Session, T, Message> messageFn) {
        Util.checkSerializable(messageFn, "messageFn");
        this.messageFn = messageFn;
        return this;
    }

    public JmsSinkBuilder<T> sendFn(DistributedBiConsumer<MessageProducer, Message> sendFn) {
        Util.checkSerializable(sendFn, "sendFn");
        this.sendFn = sendFn;
        return this;
    }

    public JmsSinkBuilder<T> flushFn(DistributedConsumer<Session> flushFn) {
        Util.checkSerializable(flushFn, "flushFn");
        this.flushFn = flushFn;
        return this;
    }

    public Sink<T> build() {
        String usernameLocal = this.username;
        String passwordLocal = this.password;
        boolean transactedLocal = this.transacted;
        int acknowledgeModeLocal = this.acknowledgeMode;
        Preconditions.checkNotNull((Object)this.destinationName);
        if (this.connectionFn == null) {
            this.connectionFn = factory -> factory.createConnection(usernameLocal, passwordLocal);
        }
        if (this.sessionFn == null) {
            this.sessionFn = connection -> connection.createSession(transactedLocal, acknowledgeModeLocal);
        }
        if (this.messageFn == null) {
            this.messageFn = (session, item) -> item instanceof Message ? (Message)item : session.createTextMessage(item.toString());
        }
        if (this.sendFn == null) {
            this.sendFn = MessageProducer::send;
        }
        if (this.flushFn == null) {
            this.flushFn = DistributedConsumer.noop();
        }
        DistributedFunction<ConnectionFactory, Connection> connectionFnLocal = this.connectionFn;
        DistributedSupplier<ConnectionFactory> factorySupplierLocal = this.factorySupplier;
        DistributedSupplier<Connection> connectionSupplier = () -> (Connection)connectionFnLocal.apply((ConnectionFactory)factorySupplierLocal.get());
        return new SinkImpl(this.sinkName(), WriteJmsP.supplier(connectionSupplier, this.sessionFn, this.messageFn, this.sendFn, this.flushFn, this.destinationName, this.isTopic));
    }

    private String sinkName() {
        return String.format("jms%sSink(%s)", this.isTopic ? "Topic" : "Queue", this.destinationName);
    }
}

