/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.impl.pipeline.transform;

import com.hazelcast.jet.Traverser;
import com.hazelcast.jet.core.Processor;
import com.hazelcast.jet.core.ProcessorSupplier;
import com.hazelcast.jet.core.processor.Processors;
import com.hazelcast.jet.function.DistributedBiFunction;
import com.hazelcast.jet.function.DistributedBiPredicate;
import com.hazelcast.jet.function.DistributedSupplier;
import com.hazelcast.jet.impl.pipeline.Planner;
import com.hazelcast.jet.impl.pipeline.transform.AbstractTransform;
import com.hazelcast.jet.impl.pipeline.transform.Transform;
import com.hazelcast.jet.pipeline.ContextFactory;
import javax.annotation.Nonnull;

public class ProcessorTransform
extends AbstractTransform {
    final ProcessorSupplier processorSupplier;

    ProcessorTransform(@Nonnull String name, @Nonnull Transform upstream, @Nonnull ProcessorSupplier processorSupplier) {
        super(name, upstream);
        this.processorSupplier = processorSupplier;
    }

    public static ProcessorTransform customProcessorTransform(@Nonnull String name, @Nonnull Transform upstream, @Nonnull DistributedSupplier<Processor> createProcessorFn) {
        return new ProcessorTransform(name, upstream, ProcessorSupplier.of(createProcessorFn));
    }

    public static <C, T, R> ProcessorTransform mapUsingContextTransform(@Nonnull Transform upstream, @Nonnull ContextFactory<C> contextFactory, @Nonnull DistributedBiFunction<? super C, ? super T, ? extends R> mapFn) {
        return new ProcessorTransform("mapUsingContext", upstream, Processors.mapUsingContextP(contextFactory, mapFn));
    }

    public static <C, T> ProcessorTransform filterUsingContextTransform(@Nonnull Transform upstream, @Nonnull ContextFactory<C> contextFactory, @Nonnull DistributedBiPredicate<? super C, ? super T> filterFn) {
        return new ProcessorTransform("filterUsingContext", upstream, Processors.filterUsingContextP(contextFactory, filterFn));
    }

    public static <C, T, R> ProcessorTransform flatMapUsingContextTransform(@Nonnull Transform upstream, @Nonnull ContextFactory<C> contextFactory, @Nonnull DistributedBiFunction<? super C, ? super T, ? extends Traverser<? extends R>> flatMapFn) {
        return new ProcessorTransform("flatMapUsingContext", upstream, Processors.flatMapUsingContextP(contextFactory, flatMapFn));
    }

    @Override
    public void addToDag(Planner p) {
        Planner.PlannerVertex pv = p.addVertex((Transform)this, p.uniqueVertexName(this.name(), ""), this.localParallelism(), this.processorSupplier);
        p.addEdges(this, pv.v);
    }
}

