/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.impl.pipeline;

import com.hazelcast.jet.aggregate.AggregateOperation1;
import com.hazelcast.jet.aggregate.AggregateOperation2;
import com.hazelcast.jet.aggregate.AggregateOperation3;
import com.hazelcast.jet.function.DistributedFunction;
import com.hazelcast.jet.function.KeyedWindowResultFunction;
import com.hazelcast.jet.impl.JetEvent;
import com.hazelcast.jet.impl.pipeline.ComputeStageImplBase;
import com.hazelcast.jet.impl.pipeline.JetEventFunctionAdapter;
import com.hazelcast.jet.impl.pipeline.StageWithGroupingBase;
import com.hazelcast.jet.impl.pipeline.StreamStageImpl;
import com.hazelcast.jet.impl.pipeline.transform.Transform;
import com.hazelcast.jet.impl.pipeline.transform.WindowGroupTransform;
import com.hazelcast.jet.impl.util.Util;
import com.hazelcast.jet.pipeline.StageWithKeyAndWindow;
import com.hazelcast.jet.pipeline.StreamStage;
import com.hazelcast.jet.pipeline.StreamStageWithKey;
import com.hazelcast.jet.pipeline.WindowDefinition;
import java.util.Arrays;
import java.util.Collections;
import javax.annotation.Nonnull;

public class StageWithKeyAndWindowImpl<T, K>
extends StageWithGroupingBase<T, K>
implements StageWithKeyAndWindow<T, K> {
    @Nonnull
    private final WindowDefinition wDef;

    StageWithKeyAndWindowImpl(@Nonnull StreamStageImpl<T> computeStage, @Nonnull DistributedFunction<? super T, ? extends K> keyFn, @Nonnull WindowDefinition wDef) {
        super(computeStage, keyFn);
        this.wDef = wDef;
    }

    @Override
    @Nonnull
    public WindowDefinition windowDefinition() {
        return this.wDef;
    }

    @Override
    @Nonnull
    public <R, OUT> StreamStage<OUT> aggregate(@Nonnull AggregateOperation1<? super T, ?, ? extends R> aggrOp, @Nonnull KeyedWindowResultFunction<? super K, ? super R, ? extends OUT> mapToOutputFn) {
        ComputeStageImplBase.ensureJetEvents(this.computeStage, "This pipeline stage");
        Util.checkSerializable(mapToOutputFn, "mapToOutputFn");
        return this.attachAggregate(aggrOp, mapToOutputFn);
    }

    private <A, R, OUT> StreamStage<OUT> attachAggregate(@Nonnull AggregateOperation1<? super T, A, R> aggrOp, @Nonnull KeyedWindowResultFunction<? super K, ? super R, ? extends OUT> mapToOutputFn) {
        JetEventFunctionAdapter fnAdapter = ComputeStageImplBase.ADAPT_TO_JET_EVENT;
        return (StreamStage)this.computeStage.attach(new WindowGroupTransform<K, R, JetEvent<? extends OUT>>(Collections.singletonList(this.computeStage.transform), this.wDef, Collections.singletonList(fnAdapter.adaptKeyFn(this.keyFn())), fnAdapter.adaptAggregateOperation1(aggrOp), fnAdapter.adaptKeyedWindowResultFn(mapToOutputFn)), fnAdapter);
    }

    @Override
    @Nonnull
    public <T1, R, OUT> StreamStage<OUT> aggregate2(@Nonnull StreamStageWithKey<T1, ? extends K> stage1, @Nonnull AggregateOperation2<? super T, ? super T1, ?, ? extends R> aggrOp, @Nonnull KeyedWindowResultFunction<? super K, ? super R, ? extends OUT> mapToOutputFn) {
        ComputeStageImplBase.ensureJetEvents(this.computeStage, "This pipeline stage");
        ComputeStageImplBase.ensureJetEvents(((StageWithGroupingBase)((Object)stage1)).computeStage, "stage1");
        Util.checkSerializable(mapToOutputFn, "mapToOutputFn");
        return this.attachAggregate2(stage1, aggrOp, mapToOutputFn);
    }

    private <T1, A, R, OUT> StreamStage<OUT> attachAggregate2(@Nonnull StreamStageWithKey<T1, ? extends K> stage1, @Nonnull AggregateOperation2<? super T, ? super T1, A, R> aggrOp, @Nonnull KeyedWindowResultFunction<? super K, ? super R, ? extends OUT> mapToOutputFn) {
        Transform upstream1 = ((StageWithGroupingBase)((Object)stage1)).computeStage.transform;
        JetEventFunctionAdapter fnAdapter = ComputeStageImplBase.ADAPT_TO_JET_EVENT;
        return (StreamStage)this.computeStage.attach(new WindowGroupTransform<K, R, JetEvent<? extends OUT>>(Arrays.asList(this.computeStage.transform, upstream1), this.wDef, Arrays.asList(fnAdapter.adaptKeyFn(this.keyFn()), fnAdapter.adaptKeyFn(stage1.keyFn())), JetEventFunctionAdapter.adaptAggregateOperation2(aggrOp), fnAdapter.adaptKeyedWindowResultFn(mapToOutputFn)), fnAdapter);
    }

    @Override
    @Nonnull
    public <T1, T2, R, OUT> StreamStage<OUT> aggregate3(@Nonnull StreamStageWithKey<T1, ? extends K> stage1, @Nonnull StreamStageWithKey<T2, ? extends K> stage2, @Nonnull AggregateOperation3<? super T, ? super T1, ? super T2, ?, ? extends R> aggrOp, @Nonnull KeyedWindowResultFunction<? super K, ? super R, ? extends OUT> mapToOutputFn) {
        ComputeStageImplBase stageImpl1 = ((StageWithGroupingBase)((Object)stage1)).computeStage;
        ComputeStageImplBase stageImpl2 = ((StageWithGroupingBase)((Object)stage2)).computeStage;
        ComputeStageImplBase.ensureJetEvents(this.computeStage, "This pipeline stage");
        ComputeStageImplBase.ensureJetEvents(stageImpl1, "stage1");
        ComputeStageImplBase.ensureJetEvents(stageImpl2, "stage2");
        Util.checkSerializable(mapToOutputFn, "mapToOutputFn");
        return this.attachAggregate3(stage1, stage2, aggrOp, mapToOutputFn);
    }

    private <T1, T2, A, R, OUT> StreamStage<OUT> attachAggregate3(@Nonnull StreamStageWithKey<T1, ? extends K> stage1, @Nonnull StreamStageWithKey<T2, ? extends K> stage2, @Nonnull AggregateOperation3<? super T, ? super T1, ? super T2, A, R> aggrOp, @Nonnull KeyedWindowResultFunction<? super K, ? super R, ? extends OUT> mapToOutputFn) {
        Transform transform1 = ((StageWithGroupingBase)((Object)stage1)).computeStage.transform;
        Transform transform2 = ((StageWithGroupingBase)((Object)stage2)).computeStage.transform;
        JetEventFunctionAdapter fnAdapter = ComputeStageImplBase.ADAPT_TO_JET_EVENT;
        return (StreamStage)this.computeStage.attach(new WindowGroupTransform<K, R, JetEvent<? extends OUT>>(Arrays.asList(this.computeStage.transform, transform1, transform2), this.wDef, Arrays.asList(fnAdapter.adaptKeyFn(this.keyFn()), fnAdapter.adaptKeyFn(stage1.keyFn()), fnAdapter.adaptKeyFn(stage2.keyFn())), JetEventFunctionAdapter.adaptAggregateOperation3(aggrOp), fnAdapter.adaptKeyedWindowResultFn(mapToOutputFn)), fnAdapter);
    }
}

