/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.impl.operation;

import com.hazelcast.jet.impl.JetService;
import com.hazelcast.jet.impl.operation.AsyncJobOperation;
import com.hazelcast.jet.impl.util.ExceptionUtil;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import java.io.IOException;
import java.util.function.BiConsumer;

public class StartExecutionOperation
extends AsyncJobOperation {
    private long executionId;

    public StartExecutionOperation() {
    }

    public StartExecutionOperation(long jobId, long executionId) {
        super(jobId);
        this.executionId = executionId;
    }

    @Override
    protected void doRun() {
        JetService service = (JetService)this.getService();
        service.getJobExecutionService().beginExecution(this.getCallerAddress(), this.jobId(), this.executionId).whenComplete((BiConsumer)ExceptionUtil.withTryCatch(this.getLogger(), (i, e) -> this.doSendResponse(e)));
    }

    public int getId() {
        return 6;
    }

    @Override
    protected void writeInternal(ObjectDataOutput out) throws IOException {
        super.writeInternal(out);
        out.writeLong(this.executionId);
    }

    @Override
    protected void readInternal(ObjectDataInput in) throws IOException {
        super.readInternal(in);
        this.executionId = in.readLong();
    }
}

