/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.impl.operation;

import com.hazelcast.jet.impl.JetService;
import com.hazelcast.jet.impl.execution.init.JetInitDataSerializerHook;
import com.hazelcast.jet.impl.util.ExceptionUtil;
import com.hazelcast.nio.serialization.IdentifiedDataSerializable;
import com.hazelcast.spi.ExceptionAction;
import com.hazelcast.spi.Operation;

public abstract class AsyncOperation
extends Operation
implements IdentifiedDataSerializable {
    public void beforeRun() {
        JetService service = (JetService)this.getService();
        service.getLiveOperationRegistry().register(this);
    }

    public final void run() {
        try {
            this.doRun();
        }
        catch (Exception e) {
            this.logError(e);
            this.doSendResponse(e);
        }
    }

    protected abstract void doRun() throws Exception;

    public final boolean returnsResponse() {
        return false;
    }

    public final Object getResponse() {
        throw new UnsupportedOperationException();
    }

    final void doSendResponse(Object value) {
        try {
            this.sendResponse(value);
        }
        finally {
            JetService service = (JetService)this.getService();
            service.getLiveOperationRegistry().deregister(this);
        }
    }

    public ExceptionAction onInvocationException(Throwable throwable) {
        return ExceptionUtil.isRestartableException(throwable) ? ExceptionAction.THROW_EXCEPTION : super.onInvocationException(throwable);
    }

    public final int getFactoryId() {
        return JetInitDataSerializerHook.FACTORY_ID;
    }
}

