/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.impl.aggregate;

import com.hazelcast.jet.aggregate.AggregateOperation;
import com.hazelcast.jet.function.DistributedBiConsumer;
import com.hazelcast.jet.function.DistributedFunction;
import com.hazelcast.jet.function.DistributedSupplier;
import com.hazelcast.jet.impl.util.Util;
import com.hazelcast.util.Preconditions;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class AggregateOperationImpl<A, R>
implements AggregateOperation<A, R> {
    final DistributedBiConsumer<? super A, ?>[] accumulateFns;
    private final DistributedSupplier<A> createFn;
    private final DistributedBiConsumer<? super A, ? super A> combineFn;
    private final DistributedBiConsumer<? super A, ? super A> deductFn;
    private final DistributedFunction<? super A, ? extends R> exportFn;
    private final DistributedFunction<? super A, ? extends R> finishFn;

    public AggregateOperationImpl(@Nonnull DistributedSupplier<A> createFn, @Nonnull DistributedBiConsumer<? super A, ?>[] accumulateFns, @Nullable DistributedBiConsumer<? super A, ? super A> combineFn, @Nullable DistributedBiConsumer<? super A, ? super A> deductFn, @Nonnull DistributedFunction<? super A, ? extends R> exportFn, @Nonnull DistributedFunction<? super A, ? extends R> finishFn) {
        for (DistributedBiConsumer<? super A, ?> f : accumulateFns) {
            Preconditions.checkNotNull(f, (String)"accumulateFns array contains a null slot");
        }
        this.createFn = createFn;
        this.accumulateFns = (DistributedBiConsumer[])accumulateFns.clone();
        this.combineFn = combineFn;
        this.deductFn = deductFn;
        this.exportFn = exportFn;
        this.finishFn = finishFn;
    }

    @Override
    public int arity() {
        return this.accumulateFns.length;
    }

    @Override
    @Nonnull
    public DistributedSupplier<A> createFn() {
        return this.createFn;
    }

    @Override
    @Nonnull
    public <T> DistributedBiConsumer<? super A, ? super T> accumulateFn(int index) {
        if (index >= this.accumulateFns.length) {
            throw new IllegalArgumentException("This AggregateOperation has " + this.accumulateFns.length + " accumulating functions, but was asked for function at index " + index);
        }
        return this.accumulateFns[index];
    }

    @Override
    @Nullable
    public DistributedBiConsumer<? super A, ? super A> combineFn() {
        return this.combineFn;
    }

    @Override
    @Nullable
    public DistributedBiConsumer<? super A, ? super A> deductFn() {
        return this.deductFn;
    }

    @Override
    @Nonnull
    public DistributedFunction<? super A, ? extends R> exportFn() {
        return this.exportFn;
    }

    @Override
    @Nonnull
    public DistributedFunction<? super A, ? extends R> finishFn() {
        return this.finishFn;
    }

    @Override
    @Nonnull
    public AggregateOperation<A, R> withAccumulateFns(DistributedBiConsumer ... accumulateFns) {
        return new AggregateOperationImpl<A, R>(this.createFn(), accumulateFns, this.combineFn(), this.deductFn(), this.exportFn(), this.finishFn());
    }

    @Override
    @Nonnull
    public AggregateOperation<A, A> withIdentityFinish() {
        Util.checkSerializable(this.finishFn, "finishFn");
        return new AggregateOperationImpl<A, A>(this.createFn(), this.accumulateFns, this.combineFn(), this.deductFn(), this.unsupportedExportFn(), DistributedFunction.identity());
    }

    @Override
    @Nonnull
    public <R_NEW> AggregateOperation<A, R_NEW> andThen(DistributedFunction<? super R, ? extends R_NEW> thenFn) {
        return new AggregateOperationImpl<A, R_NEW>(this.createFn(), this.accumulateFns, this.combineFn(), this.deductFn(), this.exportFn().andThen(thenFn), this.finishFn().andThen(thenFn));
    }

    @Nonnull
    static <A> DistributedBiConsumer<? super A, ?>[] accumulateFns(DistributedBiConsumer ... accFns) {
        return accFns;
    }

    DistributedFunction<? super A, ? extends A> unsupportedExportFn() {
        return x -> {
            throw new UnsupportedOperationException("Can't use exportFn on an aggregate operation with identity finishFn");
        };
    }
}

