/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.impl;

import com.hazelcast.core.ICompletableFuture;
import com.hazelcast.jet.config.JobConfig;
import com.hazelcast.jet.core.DAG;
import com.hazelcast.jet.core.JobStatus;
import com.hazelcast.jet.impl.AbstractJobProxy;
import com.hazelcast.jet.impl.TerminationMode;
import com.hazelcast.jet.impl.operation.GetJobConfigOperation;
import com.hazelcast.jet.impl.operation.GetJobStatusOperation;
import com.hazelcast.jet.impl.operation.GetJobSubmissionTimeOperation;
import com.hazelcast.jet.impl.operation.JoinSubmittedJobOperation;
import com.hazelcast.jet.impl.operation.ResumeJobOperation;
import com.hazelcast.jet.impl.operation.SubmitJobOperation;
import com.hazelcast.jet.impl.operation.TerminateJobOperation;
import com.hazelcast.jet.impl.util.ExceptionUtil;
import com.hazelcast.jet.impl.util.Util;
import com.hazelcast.logging.LoggingService;
import com.hazelcast.nio.Address;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.spi.Operation;
import com.hazelcast.spi.impl.NodeEngineImpl;
import com.hazelcast.spi.serialization.SerializationService;
import javax.annotation.Nonnull;

public class JobProxy
extends AbstractJobProxy<NodeEngineImpl> {
    public JobProxy(NodeEngineImpl nodeEngine, long jobId) {
        super(nodeEngine, jobId);
    }

    public JobProxy(NodeEngineImpl engine, long jobId, DAG dag, JobConfig config) {
        super(engine, jobId, dag, config);
    }

    @Override
    @Nonnull
    public JobStatus getStatus() {
        return Util.uncheckCall(() -> (JobStatus)((Object)((Object)this.invokeOp(new GetJobStatusOperation(this.getId())).get())));
    }

    @Override
    protected ICompletableFuture<Void> invokeSubmitJob(Data dag, JobConfig config) {
        return this.invokeOp(new SubmitJobOperation(this.getId(), dag, config));
    }

    @Override
    protected ICompletableFuture<Void> invokeJoinJob() {
        return this.invokeOp(new JoinSubmittedJobOperation(this.getId()));
    }

    @Override
    protected ICompletableFuture<Void> invokeTerminateJob(TerminationMode mode) {
        return this.invokeOp(new TerminateJobOperation(this.getId(), mode));
    }

    @Override
    public void resume() {
        try {
            this.invokeOp(new ResumeJobOperation(this.getId())).get();
        }
        catch (Exception e) {
            throw ExceptionUtil.rethrow(e);
        }
    }

    @Override
    protected long doGetJobSubmissionTime() {
        return Util.uncheckCall(() -> (Long)this.invokeOp(new GetJobSubmissionTimeOperation(this.getId())).get());
    }

    @Override
    protected JobConfig doGetJobConfig() {
        return Util.uncheckCall(() -> (JobConfig)this.invokeOp(new GetJobConfigOperation(this.getId())).get());
    }

    @Override
    protected Address masterAddress() {
        return ((NodeEngineImpl)this.container()).getMasterAddress();
    }

    @Override
    protected SerializationService serializationService() {
        return ((NodeEngineImpl)this.container()).getSerializationService();
    }

    @Override
    protected LoggingService loggingService() {
        return ((NodeEngineImpl)this.container()).getLoggingService();
    }

    private <T> ICompletableFuture<T> invokeOp(Operation op) {
        return ((NodeEngineImpl)this.container()).getOperationService().createInvocationBuilder("hz:impl:jetService", op, this.masterAddress()).invoke();
    }
}

