/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.impl;

import com.hazelcast.core.Cluster;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.core.ReplicatedMap;
import com.hazelcast.jet.IListJet;
import com.hazelcast.jet.IMapJet;
import com.hazelcast.jet.JetCacheManager;
import com.hazelcast.jet.JetInstance;
import com.hazelcast.jet.config.JobConfig;
import com.hazelcast.jet.impl.IListDecorator;
import com.hazelcast.jet.impl.IMapDecorator;
import com.hazelcast.jet.impl.JetCacheManagerImpl;
import com.hazelcast.jet.impl.JobRepository;
import com.hazelcast.jet.impl.util.Util;
import java.util.function.Supplier;
import javax.annotation.Nonnull;

abstract class AbstractJetInstance
implements JetInstance {
    private final HazelcastInstance hazelcastInstance;
    private final JetCacheManagerImpl cacheManager;
    private final Supplier<JobRepository> jobRepository;

    AbstractJetInstance(HazelcastInstance hazelcastInstance) {
        this.hazelcastInstance = hazelcastInstance;
        this.cacheManager = new JetCacheManagerImpl(this);
        this.jobRepository = Util.memoizeConcurrent(() -> new JobRepository(this, null));
    }

    @Override
    @Nonnull
    public Cluster getCluster() {
        return this.getHazelcastInstance().getCluster();
    }

    @Override
    @Nonnull
    public String getName() {
        return this.hazelcastInstance.getName();
    }

    @Override
    @Nonnull
    public HazelcastInstance getHazelcastInstance() {
        return this.hazelcastInstance;
    }

    @Override
    @Nonnull
    public <K, V> IMapJet<K, V> getMap(@Nonnull String name) {
        return new IMapDecorator(this.hazelcastInstance.getMap(name), this);
    }

    @Override
    @Nonnull
    public <K, V> ReplicatedMap<K, V> getReplicatedMap(@Nonnull String name) {
        return this.hazelcastInstance.getReplicatedMap(name);
    }

    @Override
    @Nonnull
    public <E> IListJet<E> getList(@Nonnull String name) {
        return new IListDecorator(this.hazelcastInstance.getList(name), this);
    }

    @Override
    @Nonnull
    public JetCacheManager getCacheManager() {
        return this.cacheManager;
    }

    @Override
    public void shutdown() {
        this.hazelcastInstance.shutdown();
    }

    long uploadResourcesAndAssignId(JobConfig config) {
        return this.jobRepository.get().uploadJobResources(config);
    }
}

