/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.function;

import com.hazelcast.jet.function.DistributedComparator;

final class DistributedComparators {
    static final DistributedComparator<Comparable<Object>> NATURAL_ORDER = new NaturalOrderComparator();
    static final DistributedComparator<Comparable<Object>> REVERSE_ORDER = new ReverseOrderComparator();

    private DistributedComparators() {
    }

    public static final class NullComparator<T>
    implements DistributedComparator<T> {
        private final boolean isNullFirst;

        NullComparator(boolean isNullFirst) {
            this.isNullFirst = isNullFirst;
        }

        @Override
        public int compareEx(T left, T right) {
            if (left == null) {
                return right == null ? 0 : (this.isNullFirst ? -1 : 1);
            }
            if (right == null) {
                return this.isNullFirst ? 1 : -1;
            }
            return 0;
        }
    }

    private static class ReverseOrderComparator
    implements DistributedComparator<Comparable<Object>> {
        private ReverseOrderComparator() {
        }

        @Override
        public int compareEx(Comparable<Object> left, Comparable<Object> right) {
            return right.compareTo(left);
        }

        @Override
        public DistributedComparator<Comparable<Object>> reversed() {
            return NATURAL_ORDER;
        }
    }

    private static class NaturalOrderComparator
    implements DistributedComparator<Comparable<Object>> {
        private NaturalOrderComparator() {
        }

        @Override
        public int compareEx(Comparable<Object> left, Comparable<Object> right) {
            return left.compareTo(right);
        }

        @Override
        public DistributedComparator<Comparable<Object>> reversed() {
            return REVERSE_ORDER;
        }
    }
}

