/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.core.test;

import com.hazelcast.jet.JetInstance;
import com.hazelcast.jet.config.ProcessingGuarantee;
import com.hazelcast.jet.core.Processor;
import com.hazelcast.jet.core.test.TestProcessorSupplierContext;
import com.hazelcast.logging.ILogger;
import javax.annotation.Nonnull;

public class TestProcessorContext
extends TestProcessorSupplierContext
implements Processor.Context {
    private int localProcessorIndex = 0;
    private int globalProcessorIndex = 0;
    private ProcessingGuarantee processingGuarantee = ProcessingGuarantee.NONE;

    @Override
    public int localProcessorIndex() {
        assert (this.localProcessorIndex >= 0 && this.localProcessorIndex < this.localParallelism()) : "localProcessorIndex should be in range 0.." + (this.localParallelism() - 1);
        return this.localProcessorIndex;
    }

    @Override
    public int globalProcessorIndex() {
        assert (this.globalProcessorIndex >= 0 && this.globalProcessorIndex < this.totalParallelism()) : "globalProcessorIndex should be in range 0.." + (this.totalParallelism() - 1);
        return this.globalProcessorIndex;
    }

    public TestProcessorContext setLocalProcessorIndex(int localProcessorIndex) {
        this.localProcessorIndex = localProcessorIndex;
        return this;
    }

    public TestProcessorContext setGlobalProcessorIndex(int globalProcessorIndex) {
        this.globalProcessorIndex = globalProcessorIndex;
        return this;
    }

    @Override
    public ProcessingGuarantee processingGuarantee() {
        return this.processingGuarantee;
    }

    @Nonnull
    public TestProcessorContext setProcessingGuarantee(ProcessingGuarantee processingGuarantee) {
        this.processingGuarantee = processingGuarantee;
        return this;
    }

    @Override
    @Nonnull
    public TestProcessorContext setLogger(@Nonnull ILogger logger) {
        return (TestProcessorContext)super.setLogger(logger);
    }

    @Override
    @Nonnull
    public TestProcessorContext setJetInstance(@Nonnull JetInstance jetInstance) {
        return (TestProcessorContext)super.setJetInstance(jetInstance);
    }

    @Override
    @Nonnull
    public TestProcessorContext setTotalParallelism(int totalParallelism) {
        return (TestProcessorContext)super.setTotalParallelism(totalParallelism);
    }

    @Override
    @Nonnull
    public TestProcessorContext setLocalParallelism(int localParallelism) {
        return (TestProcessorContext)super.setLocalParallelism(localParallelism);
    }

    @Override
    @Nonnull
    public TestProcessorContext setVertexName(@Nonnull String vertexName) {
        return (TestProcessorContext)super.setVertexName(vertexName);
    }

    @Override
    protected String loggerName() {
        return this.vertexName() + "#" + this.globalProcessorIndex;
    }
}

