/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.core;

import com.hazelcast.jet.JetException;
import com.hazelcast.jet.config.ProcessingGuarantee;
import com.hazelcast.jet.core.Inbox;
import com.hazelcast.jet.core.Outbox;
import com.hazelcast.jet.core.ProcessorSupplier;
import com.hazelcast.jet.core.Watermark;
import com.hazelcast.logging.ILogger;
import javax.annotation.Nonnull;

public interface Processor {
    default public boolean isCooperative() {
        return true;
    }

    default public void init(@Nonnull Outbox outbox, @Nonnull Context context) {
    }

    default public void process(int ordinal, @Nonnull Inbox inbox) {
    }

    default public boolean tryProcessWatermark(@Nonnull Watermark watermark) {
        return true;
    }

    default public boolean tryProcess() {
        return true;
    }

    default public boolean completeEdge(int ordinal) {
        return true;
    }

    default public boolean complete() {
        return true;
    }

    default public boolean saveToSnapshot() {
        return true;
    }

    default public void restoreFromSnapshot(@Nonnull Inbox inbox) {
        throw new JetException("Processor " + this.getClass().getName() + " does not override the restoreFromSnapshot() method");
    }

    default public boolean finishSnapshotRestore() {
        return true;
    }

    default public void close() throws Exception {
    }

    public static interface Context
    extends ProcessorSupplier.Context {
        @Override
        @Nonnull
        public ILogger logger();

        public int localProcessorIndex();

        public int globalProcessorIndex();

        default public boolean snapshottingEnabled() {
            return this.processingGuarantee() != ProcessingGuarantee.NONE;
        }

        public ProcessingGuarantee processingGuarantee();
    }
}

