/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.config;

import com.hazelcast.config.Config;
import com.hazelcast.jet.config.EdgeConfig;
import com.hazelcast.jet.config.InstanceConfig;
import com.hazelcast.jet.config.MetricsConfig;
import com.hazelcast.jet.impl.config.XmlJetConfigBuilder;
import com.hazelcast.logging.ILogger;
import com.hazelcast.logging.Logger;
import java.io.InputStream;
import java.util.Properties;
import javax.annotation.Nonnull;

public class JetConfig {
    public static final int DEFAULT_JET_MULTICAST_PORT = 54326;
    public static final String DEFAULT_GROUP_NAME = "jet";
    public static final String DEFAULT_GROUP_PASSWORD = "jet-pass";
    private static final ILogger LOGGER = Logger.getLogger(JetConfig.class);
    private Config hazelcastConfig = JetConfig.defaultHazelcastConfig();
    private InstanceConfig instanceConfig = new InstanceConfig();
    private EdgeConfig defaultEdgeConfig = new EdgeConfig();
    private MetricsConfig metricsConfig = new MetricsConfig();
    private Properties properties = new Properties();

    @Nonnull
    public static JetConfig loadDefault() {
        return XmlJetConfigBuilder.loadConfig(null, null);
    }

    @Nonnull
    public static JetConfig loadDefault(@Nonnull Properties properties) {
        return XmlJetConfigBuilder.loadConfig(null, properties);
    }

    @Nonnull
    public static JetConfig loadFromClasspath(@Nonnull String resource) {
        return JetConfig.loadFromClasspath(resource, System.getProperties());
    }

    @Nonnull
    public static JetConfig loadFromClasspath(@Nonnull String resource, @Nonnull Properties properties) {
        LOGGER.info("Configuring Hazelcast Jet from '" + resource + "' on classpath");
        InputStream stream = Thread.currentThread().getContextClassLoader().getResourceAsStream(resource);
        if (stream == null) {
            throw new IllegalArgumentException("Specified resource '" + resource + "' cannot be found on classpath");
        }
        return JetConfig.loadFromStream(stream, properties);
    }

    @Nonnull
    public static JetConfig loadFromStream(@Nonnull InputStream configStream) {
        return JetConfig.loadFromStream(configStream, System.getProperties());
    }

    @Nonnull
    public static JetConfig loadFromStream(@Nonnull InputStream configStream, @Nonnull Properties properties) {
        return XmlJetConfigBuilder.loadConfig(configStream, properties);
    }

    @Nonnull
    public Config getHazelcastConfig() {
        return this.hazelcastConfig;
    }

    @Nonnull
    public JetConfig setHazelcastConfig(@Nonnull Config config) {
        this.hazelcastConfig = config;
        return this;
    }

    @Nonnull
    public InstanceConfig getInstanceConfig() {
        return this.instanceConfig;
    }

    @Nonnull
    public JetConfig setInstanceConfig(@Nonnull InstanceConfig instanceConfig) {
        this.instanceConfig = instanceConfig;
        return this;
    }

    @Nonnull
    public MetricsConfig getMetricsConfig() {
        return this.metricsConfig;
    }

    @Nonnull
    public JetConfig setMetricsConfig(MetricsConfig metricsConfig) {
        this.metricsConfig = metricsConfig;
        return this;
    }

    public Properties getProperties() {
        return this.properties;
    }

    public JetConfig setProperties(Properties properties) {
        this.properties = properties;
        return this;
    }

    public EdgeConfig getDefaultEdgeConfig() {
        return this.defaultEdgeConfig;
    }

    public JetConfig setDefaultEdgeConfig(EdgeConfig defaultEdgeConfig) {
        this.defaultEdgeConfig = defaultEdgeConfig;
        return this;
    }

    private static Config defaultHazelcastConfig() {
        Config config = new Config();
        config.getNetworkConfig().getJoin().getMulticastConfig().setMulticastPort(54326);
        config.getGroupConfig().setName(DEFAULT_GROUP_NAME);
        config.getGroupConfig().setPassword(DEFAULT_GROUP_PASSWORD);
        return config;
    }
}

